/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.fescar.config;

import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConfigFuture {
    private static final Logger LOGGER = LoggerFactory.getLogger(ConfigFuture.class);
    private static final long DEFAULT_CONFIG_TIMEOUT = 5000L;
    private long timeoutMills;
    private long start = System.currentTimeMillis();
    private volatile Object result;
    private String dataId;
    private String content;
    private ConfigOperation operation;
    private final CountDownLatch latch = new CountDownLatch(1);

    public ConfigFuture(String dataId, String content, ConfigOperation operation) {
        this(dataId, content, operation, 5000L);
    }

    public ConfigFuture(String dataId, String content, ConfigOperation operation, long timeoutMills) {
        this.dataId = dataId;
        this.content = content;
        this.operation = operation;
        this.timeoutMills = timeoutMills;
    }

    public boolean isTimeout() {
        return System.currentTimeMillis() - this.start > this.timeoutMills;
    }

    public Object get() {
        return this.get(5000L, TimeUnit.MILLISECONDS);
    }

    public Object get(long timeout, TimeUnit unit) {
        this.timeoutMills = unit.toMillis(timeout);
        try {
            boolean success = this.latch.await(timeout, unit);
            if (!success) {
                LOGGER.error("config operation timeout,cost:" + (System.currentTimeMillis() - this.start) + " ms,op:" + this.operation.name() + ",dataId:" + this.dataId);
                return this.getFailResult();
            }
        }
        catch (InterruptedException exx) {
            LOGGER.error("config operate interrupted,error:" + exx.getMessage());
            return this.getFailResult();
        }
        if (this.operation == ConfigOperation.GET) {
            return this.result == null ? this.content : this.result;
        }
        return this.result == null ? Boolean.FALSE : this.result;
    }

    private Object getFailResult() {
        if (this.operation == ConfigOperation.GET) {
            return this.content;
        }
        return Boolean.FALSE;
    }

    public void setResult(Object result) {
        this.result = result;
        this.latch.countDown();
    }

    public String getDataId() {
        return this.dataId;
    }

    public void setDataId(String dataId) {
        this.dataId = dataId;
    }

    public String getContent() {
        return this.content;
    }

    public void setContent(String content) {
        this.content = content;
    }

    public ConfigOperation getOperation() {
        return this.operation;
    }

    public void setOperation(ConfigOperation operation) {
        this.operation = operation;
    }

    static enum ConfigOperation {
        GET,
        PUT,
        PUTIFABSENT,
        REMOVE;

    }
}

