/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.fescar.config;

import com.alibaba.fescar.common.thread.NamedThreadFactory;
import com.alibaba.fescar.config.AbstractConfiguration;
import com.alibaba.fescar.config.ConfigChangeListener;
import com.alibaba.fescar.config.ConfigFuture;
import com.typesafe.config.Config;
import com.typesafe.config.ConfigFactory;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileConfiguration
extends AbstractConfiguration<ConfigChangeListener> {
    private static final Logger LOGGER = LoggerFactory.getLogger(FileConfiguration.class);
    private final Config CONFIG;
    private ExecutorService configOperateExecutor;
    private ExecutorService configChangeExecutor;
    private static final int CORE_CONFIG_OPERATE_THREAD = 1;
    private static final int CORE_CONFIG_CHANGE_THREAD = 1;
    private static final int MAX_CONFIG_OPERATE_THREAD = 2;
    private static final long LISTENER_CONFIG_INTERNAL = 1000L;
    private static final String REGISTRY_TYPE = "file";
    private final ConcurrentMap<String, List<ConfigChangeListener>> configListenersMap = new ConcurrentHashMap<String, List<ConfigChangeListener>>(8);
    private final ConcurrentMap<String, String> listenedConfigMap = new ConcurrentHashMap<String, String>(8);

    public FileConfiguration() {
        this(null);
    }

    public FileConfiguration(String name) {
        this.CONFIG = null == name ? ConfigFactory.load() : ConfigFactory.load((String)name);
        this.configOperateExecutor = new ThreadPoolExecutor(1, 2, Integer.MAX_VALUE, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>(), (ThreadFactory)new NamedThreadFactory("configOperate", 2));
        this.configChangeExecutor = new ThreadPoolExecutor(1, 1, Integer.MAX_VALUE, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>(), (ThreadFactory)new NamedThreadFactory("configChange", 1));
        this.configChangeExecutor.submit(new ConfigChangeRunnable());
    }

    @Override
    public String getConfig(String dataId, String defaultValue, long timeoutMills) {
        ConfigFuture configFuture = new ConfigFuture(dataId, defaultValue, ConfigFuture.ConfigOperation.GET, timeoutMills);
        this.configOperateExecutor.submit(new ConfigOperateRunnable(configFuture));
        return (String)configFuture.get(timeoutMills, TimeUnit.MILLISECONDS);
    }

    @Override
    public boolean putConfig(String dataId, String content, long timeoutMills) {
        ConfigFuture configFuture = new ConfigFuture(dataId, content, ConfigFuture.ConfigOperation.PUT, timeoutMills);
        this.configOperateExecutor.submit(new ConfigOperateRunnable(configFuture));
        return (Boolean)configFuture.get();
    }

    @Override
    public boolean putConfigIfAbsent(String dataId, String content, long timeoutMills) {
        ConfigFuture configFuture = new ConfigFuture(dataId, content, ConfigFuture.ConfigOperation.PUTIFABSENT, timeoutMills);
        this.configOperateExecutor.submit(new ConfigOperateRunnable(configFuture));
        return (Boolean)configFuture.get(timeoutMills, TimeUnit.MILLISECONDS);
    }

    @Override
    public boolean removeConfig(String dataId, long timeoutMills) {
        ConfigFuture configFuture = new ConfigFuture(dataId, null, ConfigFuture.ConfigOperation.REMOVE, timeoutMills);
        this.configOperateExecutor.submit(new ConfigOperateRunnable(configFuture));
        return (Boolean)configFuture.get(timeoutMills, TimeUnit.MILLISECONDS);
    }

    @Override
    public void addConfigListener(String dataId, ConfigChangeListener listener) {
        this.configListenersMap.putIfAbsent(dataId, new ArrayList());
        ((List)this.configListenersMap.get(dataId)).add(listener);
        if (null != listener.getExecutor()) {
            ConfigChangeRunnable configChangeTask = new ConfigChangeRunnable(dataId, listener);
            listener.getExecutor().submit(configChangeTask);
        }
    }

    @Override
    public void removeConfigListener(String dataId, ConfigChangeListener listener) {
        List<ConfigChangeListener> configChangeListeners = this.getConfigListeners(dataId);
        if (configChangeListeners == null) {
            return;
        }
        ArrayList<ConfigChangeListener> newChangeListenerList = new ArrayList<ConfigChangeListener>();
        for (ConfigChangeListener changeListener : configChangeListeners) {
            if (changeListener.equals(listener)) continue;
            newChangeListenerList.add(changeListener);
        }
        this.configListenersMap.put(dataId, newChangeListenerList);
        if (null != listener.getExecutor()) {
            listener.getExecutor().shutdownNow();
        }
    }

    @Override
    public List<ConfigChangeListener> getConfigListeners(String dataId) {
        return (List)this.configListenersMap.get(dataId);
    }

    @Override
    public String getTypeName() {
        return REGISTRY_TYPE;
    }

    class ConfigChangeRunnable
    implements Runnable {
        private String dataId;
        private ConfigChangeListener listener;

        public ConfigChangeRunnable() {
        }

        public ConfigChangeRunnable(String dataId, ConfigChangeListener listener) {
            if (null == listener.getExecutor()) {
                throw new IllegalArgumentException("getExecutor is null.");
            }
            this.dataId = dataId;
            this.listener = listener;
        }

        @Override
        public void run() {
            while (true) {
                try {
                    while (true) {
                        ConcurrentHashMap configListenerMap;
                        if (null != this.dataId && null != this.listener) {
                            configListenerMap = new ConcurrentHashMap(8);
                            configListenerMap.put(this.dataId, new ArrayList());
                            ((List)configListenerMap.get(this.dataId)).add(this.listener);
                        } else {
                            configListenerMap = FileConfiguration.this.configListenersMap;
                        }
                        for (Map.Entry entry : configListenerMap.entrySet()) {
                            String configId = (String)entry.getKey();
                            String currentConfig = FileConfiguration.this.getConfig(configId);
                            if (null != currentConfig && currentConfig.equals(FileConfiguration.this.listenedConfigMap.get(configId))) {
                                FileConfiguration.this.listenedConfigMap.put(configId, currentConfig);
                                this.notifyAllListener(configId, (List)configListenerMap.get(configId));
                                continue;
                            }
                            if (null != currentConfig || null == FileConfiguration.this.listenedConfigMap.get(configId)) continue;
                            this.notifyAllListener(configId, (List)configListenerMap.get(configId));
                        }
                        Thread.sleep(1000L);
                    }
                }
                catch (Exception exx) {
                    LOGGER.error(exx.getMessage());
                    continue;
                }
                break;
            }
        }

        private void notifyAllListener(String dataId, List<ConfigChangeListener> configChangeListeners) {
            ArrayList<ConfigChangeListener> needNotifyListeners = new ArrayList<ConfigChangeListener>();
            if (null != dataId && null != this.listener) {
                needNotifyListeners.addAll(configChangeListeners);
            } else {
                for (ConfigChangeListener configChangeListener : configChangeListeners) {
                    if (null != configChangeListener.getExecutor()) continue;
                    needNotifyListeners.add(configChangeListener);
                }
            }
            for (ConfigChangeListener configChangeListener : needNotifyListeners) {
                configChangeListener.receiveConfigInfo((String)FileConfiguration.this.listenedConfigMap.get(dataId));
            }
        }
    }

    class ConfigOperateRunnable
    implements Runnable {
        private ConfigFuture configFuture;

        public ConfigOperateRunnable(ConfigFuture configFuture) {
            this.configFuture = configFuture;
        }

        @Override
        public void run() {
            if (null != this.configFuture) {
                if (this.configFuture.isTimeout()) {
                    this.setFailResult(this.configFuture);
                    return;
                }
                if (this.configFuture.getOperation() == ConfigFuture.ConfigOperation.GET) {
                    String result = FileConfiguration.this.CONFIG.getString(this.configFuture.getDataId());
                    this.configFuture.setResult(result == null ? this.configFuture.getContent() : result);
                } else if (this.configFuture.getOperation() == ConfigFuture.ConfigOperation.PUT) {
                    this.configFuture.setResult(Boolean.TRUE);
                } else if (this.configFuture.getOperation() == ConfigFuture.ConfigOperation.PUTIFABSENT) {
                    this.configFuture.setResult(Boolean.TRUE);
                } else if (this.configFuture.getOperation() == ConfigFuture.ConfigOperation.REMOVE) {
                    this.configFuture.setResult(Boolean.TRUE);
                }
            }
        }

        private void setFailResult(ConfigFuture configFuture) {
            if (configFuture.getOperation() == ConfigFuture.ConfigOperation.GET) {
                String result = configFuture.getContent();
                configFuture.setResult(result);
            } else {
                configFuture.setResult(Boolean.FALSE);
            }
        }
    }
}

