/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.client.naming.net;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.TypeReference;
import com.alibaba.fastjson.parser.Feature;
import com.alibaba.nacos.api.exception.NacosException;
import com.alibaba.nacos.api.naming.pojo.Instance;
import com.alibaba.nacos.api.naming.pojo.ListView;
import com.alibaba.nacos.api.naming.pojo.Service;
import com.alibaba.nacos.api.selector.AbstractSelector;
import com.alibaba.nacos.api.selector.ExpressionSelector;
import com.alibaba.nacos.api.selector.SelectorType;
import com.alibaba.nacos.client.config.impl.SpasAdapter;
import com.alibaba.nacos.client.monitor.MetricsMonitor;
import com.alibaba.nacos.client.naming.beat.BeatInfo;
import com.alibaba.nacos.client.naming.net.HttpClient;
import com.alibaba.nacos.client.naming.utils.CollectionUtils;
import com.alibaba.nacos.client.naming.utils.NetUtils;
import com.alibaba.nacos.client.naming.utils.SignUtil;
import com.alibaba.nacos.client.naming.utils.UtilAndComs;
import com.alibaba.nacos.client.security.SecurityProxy;
import com.alibaba.nacos.client.utils.AppNameUtils;
import com.alibaba.nacos.client.utils.LogUtils;
import com.alibaba.nacos.client.utils.TemplateUtils;
import com.alibaba.nacos.common.utils.IoUtils;
import com.alibaba.nacos.common.utils.UuidUtils;
import com.alibaba.nacos.common.utils.VersionUtils;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Random;
import java.util.concurrent.Callable;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.StringUtils;

public class NamingProxy {
    private static final int DEFAULT_SERVER_PORT = 8848;
    private int serverPort = 8848;
    private String namespaceId;
    private String endpoint;
    private String nacosDomain;
    private List<String> serverList;
    private List<String> serversFromEndpoint = new ArrayList<String>();
    private SecurityProxy securityProxy;
    private long lastSrvRefTime = 0L;
    private long vipSrvRefInterMillis = TimeUnit.SECONDS.toMillis(30L);
    private long securityInfoRefreshIntervalMills = TimeUnit.SECONDS.toMillis(5L);
    private Properties properties;

    public NamingProxy(String namespaceId, String endpoint, String serverList, Properties properties) {
        this.securityProxy = new SecurityProxy(properties);
        this.properties = properties;
        this.setServerPort(8848);
        this.namespaceId = namespaceId;
        this.endpoint = endpoint;
        if (StringUtils.isNotEmpty((CharSequence)serverList)) {
            this.serverList = Arrays.asList(serverList.split(","));
            if (this.serverList.size() == 1) {
                this.nacosDomain = serverList;
            }
        }
        this.initRefreshTask();
    }

    private void initRefreshTask() {
        ScheduledThreadPoolExecutor executorService = new ScheduledThreadPoolExecutor(2, new ThreadFactory(){

            @Override
            public Thread newThread(Runnable r) {
                Thread t = new Thread(r);
                t.setName("com.alibaba.nacos.client.naming.updater");
                t.setDaemon(true);
                return t;
            }
        });
        executorService.scheduleWithFixedDelay(new Runnable(){

            @Override
            public void run() {
                NamingProxy.this.refreshSrvIfNeed();
            }
        }, 0L, this.vipSrvRefInterMillis, TimeUnit.MILLISECONDS);
        executorService.scheduleWithFixedDelay(new Runnable(){

            @Override
            public void run() {
                NamingProxy.this.securityProxy.login(NamingProxy.this.getServerList());
            }
        }, 0L, this.securityInfoRefreshIntervalMills, TimeUnit.MILLISECONDS);
        this.refreshSrvIfNeed();
        this.securityProxy.login(this.getServerList());
    }

    public List<String> getServerListFromEndpoint() {
        try {
            String urlString = "http://" + this.endpoint + "/nacos/serverlist";
            List<String> headers = this.builderHeaders();
            HttpClient.HttpResult result = HttpClient.httpGet(urlString, headers, null, "UTF-8");
            if (200 != result.code) {
                throw new IOException("Error while requesting: " + urlString + "'. Server returned: " + result.code);
            }
            String content = result.content;
            ArrayList<String> list = new ArrayList<String>();
            for (String line : IoUtils.readLines((Reader)new StringReader(content))) {
                if (line.trim().isEmpty()) continue;
                list.add(line.trim());
            }
            return list;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    private void refreshSrvIfNeed() {
        try {
            if (!CollectionUtils.isEmpty(this.serverList)) {
                LogUtils.NAMING_LOGGER.debug("server list provided by user: " + this.serverList);
                return;
            }
            if (System.currentTimeMillis() - this.lastSrvRefTime < this.vipSrvRefInterMillis) {
                return;
            }
            List<String> list = this.getServerListFromEndpoint();
            if (CollectionUtils.isEmpty(list)) {
                throw new Exception("Can not acquire Nacos list");
            }
            if (!CollectionUtils.isEqualCollection(list, this.serversFromEndpoint)) {
                LogUtils.NAMING_LOGGER.info("[SERVER-LIST] server list is updated: " + list);
            }
            this.serversFromEndpoint = list;
            this.lastSrvRefTime = System.currentTimeMillis();
        }
        catch (Throwable e) {
            LogUtils.NAMING_LOGGER.warn("failed to update server list", e);
        }
    }

    public void registerService(String serviceName, String groupName, Instance instance) throws NacosException {
        LogUtils.NAMING_LOGGER.info("[REGISTER-SERVICE] {} registering service {} with instance: {}", new Object[]{this.namespaceId, serviceName, instance});
        HashMap<String, String> params = new HashMap<String, String>(9);
        params.put("namespaceId", this.namespaceId);
        params.put("serviceName", serviceName);
        params.put("groupName", groupName);
        params.put("clusterName", instance.getClusterName());
        params.put("ip", instance.getIp());
        params.put("port", String.valueOf(instance.getPort()));
        params.put("weight", String.valueOf(instance.getWeight()));
        params.put("enable", String.valueOf(instance.isEnabled()));
        params.put("healthy", String.valueOf(instance.isHealthy()));
        params.put("ephemeral", String.valueOf(instance.isEphemeral()));
        params.put("metadata", JSON.toJSONString((Object)instance.getMetadata()));
        this.reqAPI(UtilAndComs.NACOS_URL_INSTANCE, params, "POST");
    }

    public void deregisterService(String serviceName, Instance instance) throws NacosException {
        LogUtils.NAMING_LOGGER.info("[DEREGISTER-SERVICE] {} deregistering service {} with instance: {}", new Object[]{this.namespaceId, serviceName, instance});
        HashMap<String, String> params = new HashMap<String, String>(8);
        params.put("namespaceId", this.namespaceId);
        params.put("serviceName", serviceName);
        params.put("clusterName", instance.getClusterName());
        params.put("ip", instance.getIp());
        params.put("port", String.valueOf(instance.getPort()));
        params.put("ephemeral", String.valueOf(instance.isEphemeral()));
        this.reqAPI(UtilAndComs.NACOS_URL_INSTANCE, params, "DELETE");
    }

    public void updateInstance(String serviceName, String groupName, Instance instance) throws NacosException {
        LogUtils.NAMING_LOGGER.info("[UPDATE-SERVICE] {} update service {} with instance: {}", new Object[]{this.namespaceId, serviceName, instance});
        HashMap<String, String> params = new HashMap<String, String>(8);
        params.put("namespaceId", this.namespaceId);
        params.put("serviceName", serviceName);
        params.put("groupName", groupName);
        params.put("clusterName", instance.getClusterName());
        params.put("ip", instance.getIp());
        params.put("port", String.valueOf(instance.getPort()));
        params.put("weight", String.valueOf(instance.getWeight()));
        params.put("enabled", String.valueOf(instance.isEnabled()));
        params.put("ephemeral", String.valueOf(instance.isEphemeral()));
        params.put("metadata", JSON.toJSONString((Object)instance.getMetadata()));
        this.reqAPI(UtilAndComs.NACOS_URL_INSTANCE, params, "PUT");
    }

    public Service queryService(String serviceName, String groupName) throws NacosException {
        LogUtils.NAMING_LOGGER.info("[QUERY-SERVICE] {} query service : {}, {}", new Object[]{this.namespaceId, serviceName, groupName});
        HashMap<String, String> params = new HashMap<String, String>(3);
        params.put("namespaceId", this.namespaceId);
        params.put("serviceName", serviceName);
        params.put("groupName", groupName);
        String result = this.reqAPI(UtilAndComs.NACOS_URL_SERVICE, params, "GET");
        JSONObject jsonObject = JSON.parseObject((String)result);
        return (Service)jsonObject.toJavaObject(Service.class);
    }

    public void createService(Service service, AbstractSelector selector) throws NacosException {
        LogUtils.NAMING_LOGGER.info("[CREATE-SERVICE] {} creating service : {}", (Object)this.namespaceId, (Object)service);
        HashMap<String, String> params = new HashMap<String, String>(6);
        params.put("namespaceId", this.namespaceId);
        params.put("serviceName", service.getName());
        params.put("groupName", service.getGroupName());
        params.put("protectThreshold", String.valueOf(service.getProtectThreshold()));
        params.put("metadata", JSON.toJSONString((Object)service.getMetadata()));
        params.put("selector", JSON.toJSONString((Object)selector));
        this.reqAPI(UtilAndComs.NACOS_URL_SERVICE, params, "POST");
    }

    public boolean deleteService(String serviceName, String groupName) throws NacosException {
        LogUtils.NAMING_LOGGER.info("[DELETE-SERVICE] {} deleting service : {} with groupName : {}", new Object[]{this.namespaceId, serviceName, groupName});
        HashMap<String, String> params = new HashMap<String, String>(6);
        params.put("namespaceId", this.namespaceId);
        params.put("serviceName", serviceName);
        params.put("groupName", groupName);
        String result = this.reqAPI(UtilAndComs.NACOS_URL_SERVICE, params, "DELETE");
        return "ok".equals(result);
    }

    public void updateService(Service service, AbstractSelector selector) throws NacosException {
        LogUtils.NAMING_LOGGER.info("[UPDATE-SERVICE] {} updating service : {}", (Object)this.namespaceId, (Object)service);
        HashMap<String, String> params = new HashMap<String, String>(6);
        params.put("namespaceId", this.namespaceId);
        params.put("serviceName", service.getName());
        params.put("groupName", service.getGroupName());
        params.put("protectThreshold", String.valueOf(service.getProtectThreshold()));
        params.put("metadata", JSON.toJSONString((Object)service.getMetadata()));
        params.put("selector", JSON.toJSONString((Object)selector));
        this.reqAPI(UtilAndComs.NACOS_URL_SERVICE, params, "PUT");
    }

    public String queryList(String serviceName, String clusters, int udpPort, boolean healthyOnly) throws NacosException {
        HashMap<String, String> params = new HashMap<String, String>(8);
        params.put("namespaceId", this.namespaceId);
        params.put("serviceName", serviceName);
        params.put("clusters", clusters);
        params.put("udpPort", String.valueOf(udpPort));
        params.put("clientIP", NetUtils.localIP());
        params.put("healthyOnly", String.valueOf(healthyOnly));
        return this.reqAPI(UtilAndComs.NACOS_URL_BASE + "/instance/list", params, "GET");
    }

    public JSONObject sendBeat(BeatInfo beatInfo, boolean lightBeatEnabled) throws NacosException {
        if (LogUtils.NAMING_LOGGER.isDebugEnabled()) {
            LogUtils.NAMING_LOGGER.debug("[BEAT] {} sending beat to server: {}", (Object)this.namespaceId, (Object)beatInfo.toString());
        }
        HashMap<String, String> params = new HashMap<String, String>(8);
        String body = "";
        if (!lightBeatEnabled) {
            body = "beat=" + JSON.toJSONString((Object)beatInfo);
        }
        params.put("namespaceId", this.namespaceId);
        params.put("serviceName", beatInfo.getServiceName());
        params.put("clusterName", beatInfo.getCluster());
        params.put("ip", beatInfo.getIp());
        params.put("port", String.valueOf(beatInfo.getPort()));
        String result = this.reqAPI(UtilAndComs.NACOS_URL_BASE + "/instance/beat", params, body, "PUT");
        return JSON.parseObject((String)result);
    }

    public boolean serverHealthy() {
        try {
            String result = this.reqAPI(UtilAndComs.NACOS_URL_BASE + "/operator/metrics", new HashMap<String, String>(2), "GET");
            JSONObject json = JSON.parseObject((String)result);
            String serverStatus = json.getString("status");
            return "UP".equals(serverStatus);
        }
        catch (Exception e) {
            return false;
        }
    }

    public ListView<String> getServiceList(int pageNo, int pageSize, String groupName) throws NacosException {
        return this.getServiceList(pageNo, pageSize, groupName, null);
    }

    public ListView<String> getServiceList(int pageNo, int pageSize, String groupName, AbstractSelector selector) throws NacosException {
        HashMap<String, String> params = new HashMap<String, String>(4);
        params.put("pageNo", String.valueOf(pageNo));
        params.put("pageSize", String.valueOf(pageSize));
        params.put("namespaceId", this.namespaceId);
        params.put("groupName", groupName);
        if (selector != null) {
            switch (SelectorType.valueOf((String)selector.getType())) {
                case none: {
                    break;
                }
                case label: {
                    ExpressionSelector expressionSelector = (ExpressionSelector)selector;
                    params.put("selector", JSON.toJSONString((Object)expressionSelector));
                    break;
                }
            }
        }
        String result = this.reqAPI(UtilAndComs.NACOS_URL_BASE + "/service/list", params, "GET");
        JSONObject json = JSON.parseObject((String)result);
        ListView listView = new ListView();
        listView.setCount(json.getInteger("count").intValue());
        listView.setData((List)JSON.parseObject((String)json.getString("doms"), (TypeReference)new TypeReference<List<String>>(){}, (Feature[])new Feature[0]));
        return listView;
    }

    public String reqAPI(String api, Map<String, String> params, String method) throws NacosException {
        return this.reqAPI(api, params, "", method);
    }

    public String reqAPI(String api, Map<String, String> params, String body, String method) throws NacosException {
        return this.reqAPI(api, params, body, this.getServerList(), method);
    }

    private List<String> getServerList() {
        List<String> snapshot = this.serversFromEndpoint;
        if (!CollectionUtils.isEmpty(this.serverList)) {
            snapshot = this.serverList;
        }
        return snapshot;
    }

    public String callServer(String api, Map<String, String> params, String body, String curServer) throws NacosException {
        return this.callServer(api, params, body, curServer, "GET");
    }

    public String callServer(String api, Map<String, String> params, String body, String curServer, String method) throws NacosException {
        String url;
        long start = System.currentTimeMillis();
        long end = 0L;
        this.injectSecurityInfo(params);
        List<String> headers = this.builderHeaders();
        if (curServer.startsWith("https://") || curServer.startsWith("http://")) {
            url = curServer + api;
        } else {
            if (!curServer.contains(":")) {
                curServer = curServer + ":" + this.serverPort;
            }
            url = HttpClient.getPrefix() + curServer + api;
        }
        HttpClient.HttpResult result = HttpClient.request(url, headers, params, body, "UTF-8", method);
        end = System.currentTimeMillis();
        MetricsMonitor.getNamingRequestMonitor(method, url, String.valueOf(result.code)).observe((double)(end - start));
        if (200 == result.code) {
            return result.content;
        }
        if (304 == result.code) {
            return "";
        }
        throw new NacosException(result.code, result.content);
    }

    public String reqAPI(String api, Map<String, String> params, String body, List<String> servers, String method) throws NacosException {
        params.put("namespaceId", this.getNamespaceId());
        if (CollectionUtils.isEmpty(servers) && StringUtils.isEmpty((CharSequence)this.nacosDomain)) {
            throw new NacosException(400, "no server available");
        }
        NacosException exception = new NacosException();
        if (servers != null && !servers.isEmpty()) {
            Random random = new Random(System.currentTimeMillis());
            int index = random.nextInt(servers.size());
            for (int i = 0; i < servers.size(); ++i) {
                String server = servers.get(index);
                try {
                    return this.callServer(api, params, body, server, method);
                }
                catch (NacosException e) {
                    exception = e;
                    if (LogUtils.NAMING_LOGGER.isDebugEnabled()) {
                        LogUtils.NAMING_LOGGER.debug("request {} failed.", (Object)server, (Object)e);
                    }
                    index = (index + 1) % servers.size();
                    continue;
                }
            }
        }
        if (StringUtils.isNotBlank((CharSequence)this.nacosDomain)) {
            for (int i = 0; i < 3; ++i) {
                try {
                    return this.callServer(api, params, body, this.nacosDomain, method);
                }
                catch (NacosException e) {
                    exception = e;
                    if (!LogUtils.NAMING_LOGGER.isDebugEnabled()) continue;
                    LogUtils.NAMING_LOGGER.debug("request {} failed.", (Object)this.nacosDomain, (Object)e);
                    continue;
                }
            }
        }
        LogUtils.NAMING_LOGGER.error("request: {} failed, servers: {}, code: {}, msg: {}", new Object[]{api, servers, exception.getErrCode(), exception.getErrMsg()});
        throw new NacosException(exception.getErrCode(), "failed to req API:/api/" + api + " after all servers(" + servers + ") tried: " + exception.getMessage());
    }

    private void injectSecurityInfo(Map<String, String> params) {
        if (StringUtils.isNotBlank((CharSequence)this.securityProxy.getAccessToken())) {
            params.put("accessToken", this.securityProxy.getAccessToken());
        }
        String ak = this.getAccessKey();
        String sk = this.getSecretKey();
        params.put("app", AppNameUtils.getAppName());
        if (StringUtils.isNotBlank((CharSequence)ak) && StringUtils.isNotBlank((CharSequence)sk)) {
            try {
                String signData = NamingProxy.getSignData(params.get("serviceName"));
                String signature = SignUtil.sign(signData, sk);
                params.put("signature", signature);
                params.put("data", signData);
                params.put("ak", ak);
            }
            catch (Exception e) {
                LogUtils.NAMING_LOGGER.error("inject ak/sk failed.", (Throwable)e);
            }
        }
    }

    public List<String> builderHeaders() {
        List<String> headers = Arrays.asList("Client-Version", VersionUtils.VERSION, "User-Agent", UtilAndComs.VERSION, "Accept-Encoding", "gzip,deflate,sdch", "Connection", "Keep-Alive", "RequestId", UuidUtils.generateUuid(), "Request-Module", "Naming");
        return headers;
    }

    private static String getSignData(String serviceName) {
        return StringUtils.isNotEmpty((CharSequence)serviceName) ? System.currentTimeMillis() + "@@" + serviceName : String.valueOf(System.currentTimeMillis());
    }

    public String getAccessKey() {
        if (this.properties == null) {
            return SpasAdapter.getAk();
        }
        return TemplateUtils.stringEmptyAndThenExecute(this.properties.getProperty("accessKey"), new Callable<String>(){

            @Override
            public String call() {
                return SpasAdapter.getAk();
            }
        });
    }

    public String getSecretKey() {
        if (this.properties == null) {
            return SpasAdapter.getSk();
        }
        return TemplateUtils.stringEmptyAndThenExecute(this.properties.getProperty("secretKey"), new Callable<String>(){

            @Override
            public String call() throws Exception {
                return SpasAdapter.getSk();
            }
        });
    }

    public void setProperties(Properties properties) {
        this.properties = properties;
        this.setServerPort(8848);
    }

    public String getNamespaceId() {
        return this.namespaceId;
    }

    public void setServerPort(int serverPort) {
        this.serverPort = serverPort;
        String sp = System.getProperty("nacos.naming.exposed.port");
        if (StringUtils.isNotBlank((CharSequence)sp)) {
            this.serverPort = Integer.parseInt(sp);
        }
    }
}

