/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.ververica.cdc.debezium.table;

import com.alibaba.ververica.cdc.debezium.DebeziumDeserializationSchema;
import com.alibaba.ververica.cdc.debezium.utils.TemporalConversions;
import io.debezium.data.Envelope;
import io.debezium.data.SpecialValueDecimal;
import io.debezium.data.VariableScaleDecimal;
import java.io.Serializable;
import java.math.BigDecimal;
import java.nio.ByteBuffer;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneId;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.table.data.DecimalData;
import org.apache.flink.table.data.GenericRowData;
import org.apache.flink.table.data.RowData;
import org.apache.flink.table.data.StringData;
import org.apache.flink.table.data.TimestampData;
import org.apache.flink.table.types.logical.DecimalType;
import org.apache.flink.table.types.logical.LogicalType;
import org.apache.flink.table.types.logical.RowType;
import org.apache.flink.types.RowKind;
import org.apache.flink.util.Collector;
import org.apache.kafka.connect.data.Decimal;
import org.apache.kafka.connect.data.Schema;
import org.apache.kafka.connect.data.Struct;
import org.apache.kafka.connect.source.SourceRecord;

public final class RowDataDebeziumDeserializeSchema
implements DebeziumDeserializationSchema<RowData> {
    private static final long serialVersionUID = -4852684966051743776L;
    private final TypeInformation<RowData> resultTypeInfo;
    private final DeserializationRuntimeConverter runtimeConverter;
    private final ZoneId serverTimeZone;
    private final ValueValidator validator;

    public RowDataDebeziumDeserializeSchema(RowType rowType, TypeInformation<RowData> resultTypeInfo, ValueValidator validator, ZoneId serverTimeZone) {
        this.runtimeConverter = this.createConverter((LogicalType)rowType);
        this.resultTypeInfo = resultTypeInfo;
        this.validator = validator;
        this.serverTimeZone = serverTimeZone;
    }

    @Override
    public void deserialize(SourceRecord record, Collector<RowData> out) throws Exception {
        Envelope.Operation op = Envelope.operationFor(record);
        Struct value = (Struct)record.value();
        Schema valueSchema = record.valueSchema();
        if (op == Envelope.Operation.CREATE || op == Envelope.Operation.READ) {
            GenericRowData insert = this.extractAfterRow(value, valueSchema);
            this.validator.validate((RowData)insert, RowKind.INSERT);
            insert.setRowKind(RowKind.INSERT);
            out.collect((Object)insert);
        } else if (op == Envelope.Operation.DELETE) {
            GenericRowData delete = this.extractBeforeRow(value, valueSchema);
            this.validator.validate((RowData)delete, RowKind.DELETE);
            delete.setRowKind(RowKind.DELETE);
            out.collect((Object)delete);
        } else {
            GenericRowData before = this.extractBeforeRow(value, valueSchema);
            this.validator.validate((RowData)before, RowKind.UPDATE_BEFORE);
            before.setRowKind(RowKind.UPDATE_BEFORE);
            out.collect((Object)before);
            GenericRowData after = this.extractAfterRow(value, valueSchema);
            this.validator.validate((RowData)after, RowKind.UPDATE_AFTER);
            after.setRowKind(RowKind.UPDATE_AFTER);
            out.collect((Object)after);
        }
    }

    private GenericRowData extractAfterRow(Struct value, Schema valueSchema) throws Exception {
        Schema afterSchema = valueSchema.field("after").schema();
        Struct after = value.getStruct("after");
        return (GenericRowData)this.runtimeConverter.convert(after, afterSchema);
    }

    private GenericRowData extractBeforeRow(Struct value, Schema valueSchema) throws Exception {
        Schema afterSchema = valueSchema.field("before").schema();
        Struct after = value.getStruct("before");
        return (GenericRowData)this.runtimeConverter.convert(after, afterSchema);
    }

    public TypeInformation<RowData> getProducedType() {
        return this.resultTypeInfo;
    }

    private DeserializationRuntimeConverter createConverter(LogicalType type) {
        return this.wrapIntoNullableConverter(this.createNotNullConverter(type));
    }

    private DeserializationRuntimeConverter createNotNullConverter(LogicalType type) {
        switch (type.getTypeRoot()) {
            case NULL: {
                return (dbzObj, schema) -> null;
            }
            case BOOLEAN: {
                return this::convertToBoolean;
            }
            case TINYINT: {
                return (dbzObj, schema) -> Byte.parseByte(dbzObj.toString());
            }
            case SMALLINT: {
                return (dbzObj, schema) -> Short.parseShort(dbzObj.toString());
            }
            case INTEGER: 
            case INTERVAL_YEAR_MONTH: {
                return this::convertToInt;
            }
            case BIGINT: 
            case INTERVAL_DAY_TIME: {
                return this::convertToLong;
            }
            case DATE: {
                return this::convertToDate;
            }
            case TIME_WITHOUT_TIME_ZONE: {
                return this::convertToTime;
            }
            case TIMESTAMP_WITHOUT_TIME_ZONE: {
                return this::convertToTimestamp;
            }
            case TIMESTAMP_WITH_LOCAL_TIME_ZONE: {
                return this::convertToLocalTimeZoneTimestamp;
            }
            case FLOAT: {
                return this::convertToFloat;
            }
            case DOUBLE: {
                return this::convertToDouble;
            }
            case CHAR: 
            case VARCHAR: {
                return this::convertToString;
            }
            case BINARY: 
            case VARBINARY: {
                return this::convertToBinary;
            }
            case DECIMAL: {
                return this.createDecimalConverter((DecimalType)type);
            }
            case ROW: {
                return this.createRowConverter((RowType)type);
            }
        }
        throw new UnsupportedOperationException("Unsupported type: " + type);
    }

    private boolean convertToBoolean(Object dbzObj, Schema schema) {
        if (dbzObj instanceof Boolean) {
            return (Boolean)dbzObj;
        }
        if (dbzObj instanceof Byte) {
            return (Byte)dbzObj == 1;
        }
        if (dbzObj instanceof Short) {
            return (Short)dbzObj == 1;
        }
        return Boolean.parseBoolean(dbzObj.toString());
    }

    private int convertToInt(Object dbzObj, Schema schema) {
        if (dbzObj instanceof Integer) {
            return (Integer)dbzObj;
        }
        if (dbzObj instanceof Long) {
            return ((Long)dbzObj).intValue();
        }
        return Integer.parseInt(dbzObj.toString());
    }

    private long convertToLong(Object dbzObj, Schema schema) {
        if (dbzObj instanceof Integer) {
            return (Long)dbzObj;
        }
        if (dbzObj instanceof Long) {
            return (Long)dbzObj;
        }
        return Long.parseLong(dbzObj.toString());
    }

    private double convertToDouble(Object dbzObj, Schema schema) {
        if (dbzObj instanceof Float) {
            return (Double)dbzObj;
        }
        if (dbzObj instanceof Double) {
            return (Double)dbzObj;
        }
        return Double.parseDouble(dbzObj.toString());
    }

    private float convertToFloat(Object dbzObj, Schema schema) {
        if (dbzObj instanceof Float) {
            return ((Float)dbzObj).floatValue();
        }
        if (dbzObj instanceof Double) {
            return ((Double)dbzObj).floatValue();
        }
        return Float.parseFloat(dbzObj.toString());
    }

    private int convertToDate(Object dbzObj, Schema schema) {
        return (int)TemporalConversions.toLocalDate(dbzObj).toEpochDay();
    }

    private int convertToTime(Object dbzObj, Schema schema) {
        if (dbzObj instanceof Long) {
            switch (schema.name()) {
                case "io.debezium.time.MicroTime": {
                    return (int)((Long)dbzObj / 1000L);
                }
                case "io.debezium.time.NanoTime": {
                    return (int)((Long)dbzObj / 1000000L);
                }
            }
        } else if (dbzObj instanceof Integer) {
            return (Integer)dbzObj;
        }
        return TemporalConversions.toLocalTime(dbzObj).toSecondOfDay() * 1000;
    }

    private TimestampData convertToTimestamp(Object dbzObj, Schema schema) {
        if (dbzObj instanceof Long) {
            switch (schema.name()) {
                case "io.debezium.time.Timestamp": {
                    return TimestampData.fromEpochMillis((long)((Long)dbzObj));
                }
                case "io.debezium.time.MicroTimestamp": {
                    long micro = (Long)dbzObj;
                    return TimestampData.fromEpochMillis((long)(micro / 1000L), (int)((int)(micro % 1000L * 1000L)));
                }
                case "io.debezium.time.NanoTimestamp": {
                    long nano = (Long)dbzObj;
                    return TimestampData.fromEpochMillis((long)(nano / 1000000L), (int)((int)(nano % 1000000L)));
                }
            }
        }
        LocalDateTime localDateTime = TemporalConversions.toLocalDateTime(dbzObj, this.serverTimeZone);
        return TimestampData.fromLocalDateTime((LocalDateTime)localDateTime);
    }

    private TimestampData convertToLocalTimeZoneTimestamp(Object dbzObj, Schema schema) {
        if (dbzObj instanceof String) {
            String str = (String)dbzObj;
            Instant instant = Instant.parse(str);
            return TimestampData.fromLocalDateTime((LocalDateTime)LocalDateTime.ofInstant(instant, this.serverTimeZone));
        }
        throw new IllegalArgumentException("Unable to convert to TimestampData from unexpected value '" + dbzObj + "' of type " + dbzObj.getClass().getName());
    }

    private StringData convertToString(Object dbzObj, Schema schema) {
        return StringData.fromString((String)dbzObj.toString());
    }

    private byte[] convertToBinary(Object dbzObj, Schema schema) {
        if (dbzObj instanceof byte[]) {
            return (byte[])dbzObj;
        }
        if (dbzObj instanceof ByteBuffer) {
            ByteBuffer byteBuffer = (ByteBuffer)dbzObj;
            byte[] bytes = new byte[byteBuffer.remaining()];
            byteBuffer.get(bytes);
            return bytes;
        }
        throw new UnsupportedOperationException("Unsupported BYTES value type: " + dbzObj.getClass().getSimpleName());
    }

    private DeserializationRuntimeConverter createDecimalConverter(DecimalType decimalType) {
        int precision = decimalType.getPrecision();
        int scale = decimalType.getScale();
        return (dbzObj, schema) -> {
            BigDecimal bigDecimal;
            if (dbzObj instanceof byte[]) {
                bigDecimal = Decimal.toLogical(schema, (byte[])dbzObj);
            } else if (dbzObj instanceof String) {
                bigDecimal = new BigDecimal((String)dbzObj);
            } else if (dbzObj instanceof Double) {
                bigDecimal = BigDecimal.valueOf((Double)dbzObj);
            } else if ("io.debezium.data.VariableScaleDecimal".equals(schema.name())) {
                SpecialValueDecimal decimal = VariableScaleDecimal.toLogical((Struct)dbzObj);
                bigDecimal = decimal.getDecimalValue().orElse(BigDecimal.ZERO);
            } else {
                bigDecimal = new BigDecimal(dbzObj.toString());
            }
            return DecimalData.fromBigDecimal((BigDecimal)bigDecimal, (int)precision, (int)scale);
        };
    }

    private DeserializationRuntimeConverter createRowConverter(RowType rowType) {
        DeserializationRuntimeConverter[] fieldConverters = (DeserializationRuntimeConverter[])rowType.getFields().stream().map(RowType.RowField::getType).map(this::createConverter).toArray(DeserializationRuntimeConverter[]::new);
        String[] fieldNames = rowType.getFieldNames().toArray(new String[0]);
        return (dbzObj, schema) -> {
            Struct struct = (Struct)dbzObj;
            int arity = fieldNames.length;
            GenericRowData row = new GenericRowData(arity);
            for (int i = 0; i < arity; ++i) {
                String fieldName = fieldNames[i];
                Object fieldValue = struct.get(fieldName);
                Schema fieldSchema = schema.field(fieldName).schema();
                Object convertedField = this.convertField(fieldConverters[i], fieldValue, fieldSchema);
                row.setField(i, convertedField);
            }
            return row;
        };
    }

    private Object convertField(DeserializationRuntimeConverter fieldConverter, Object fieldValue, Schema fieldSchema) throws Exception {
        if (fieldValue == null) {
            return null;
        }
        return fieldConverter.convert(fieldValue, fieldSchema);
    }

    private DeserializationRuntimeConverter wrapIntoNullableConverter(DeserializationRuntimeConverter converter) {
        return (dbzObj, schema) -> {
            if (dbzObj == null) {
                return null;
            }
            return converter.convert(dbzObj, schema);
        };
    }

    @FunctionalInterface
    private static interface DeserializationRuntimeConverter
    extends Serializable {
        public Object convert(Object var1, Schema var2) throws Exception;
    }

    public static interface ValueValidator
    extends Serializable {
        public void validate(RowData var1, RowKind var2) throws Exception;
    }
}

