/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.connect.transforms;

import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.kafka.common.cache.Cache;
import org.apache.kafka.common.cache.LRUCache;
import org.apache.kafka.common.cache.SynchronizedCache;
import org.apache.kafka.common.config.ConfigDef;
import org.apache.kafka.connect.connector.ConnectRecord;
import org.apache.kafka.connect.data.ConnectSchema;
import org.apache.kafka.connect.data.Field;
import org.apache.kafka.connect.data.Schema;
import org.apache.kafka.connect.data.SchemaBuilder;
import org.apache.kafka.connect.data.Struct;
import org.apache.kafka.connect.errors.DataException;
import org.apache.kafka.connect.transforms.Transformation;
import org.apache.kafka.connect.transforms.util.Requirements;
import org.apache.kafka.connect.transforms.util.SchemaUtil;
import org.apache.kafka.connect.transforms.util.SimpleConfig;

public abstract class Flatten<R extends ConnectRecord<R>>
implements Transformation<R> {
    public static final String OVERVIEW_DOC = "Flatten a nested data structure, generating names for each field by concatenating the field names at each level with a configurable delimiter character. Applies to Struct when schema present, or a Map in the case of schemaless data. The default delimiter is '.'.<p/>Use the concrete transformation type designed for the record key (<code>" + Key.class.getName() + "</code>) or value (<code>" + Value.class.getName() + "</code>).";
    private static final String DELIMITER_CONFIG = "delimiter";
    private static final String DELIMITER_DEFAULT = ".";
    public static final ConfigDef CONFIG_DEF = new ConfigDef().define("delimiter", ConfigDef.Type.STRING, ".", ConfigDef.Importance.MEDIUM, "Delimiter to insert between field names from the input record when generating field names for the output record");
    private static final String PURPOSE = "flattening";
    private String delimiter;
    private Cache<Schema, Schema> schemaUpdateCache;

    @Override
    public void configure(Map<String, ?> props) {
        SimpleConfig config = new SimpleConfig(CONFIG_DEF, props);
        this.delimiter = config.getString(DELIMITER_CONFIG);
        this.schemaUpdateCache = new SynchronizedCache<Schema, Schema>(new LRUCache(16));
    }

    @Override
    public R apply(R record) {
        if (this.operatingValue(record) == null) {
            return record;
        }
        if (this.operatingSchema(record) == null) {
            return this.applySchemaless(record);
        }
        return this.applyWithSchema(record);
    }

    @Override
    public void close() {
    }

    @Override
    public ConfigDef config() {
        return CONFIG_DEF;
    }

    protected abstract Schema operatingSchema(R var1);

    protected abstract Object operatingValue(R var1);

    protected abstract R newRecord(R var1, Schema var2, Object var3);

    private R applySchemaless(R record) {
        Map<String, Object> value = Requirements.requireMap(this.operatingValue(record), PURPOSE);
        LinkedHashMap<String, Object> newValue = new LinkedHashMap<String, Object>();
        this.applySchemaless(value, "", newValue);
        return this.newRecord(record, null, newValue);
    }

    private void applySchemaless(Map<String, Object> originalRecord, String fieldNamePrefix, Map<String, Object> newRecord) {
        block4: for (Map.Entry<String, Object> entry : originalRecord.entrySet()) {
            String fieldName = this.fieldName(fieldNamePrefix, entry.getKey());
            Object value = entry.getValue();
            if (value == null) {
                newRecord.put(this.fieldName(fieldNamePrefix, entry.getKey()), null);
                return;
            }
            Schema.Type inferredType = ConnectSchema.schemaType(value.getClass());
            if (inferredType == null) {
                throw new DataException("Flatten transformation was passed a value of type " + value.getClass() + " which is not supported by Connect's data API");
            }
            switch (inferredType) {
                case INT8: 
                case INT16: 
                case INT32: 
                case INT64: 
                case FLOAT32: 
                case FLOAT64: 
                case BOOLEAN: 
                case STRING: 
                case BYTES: {
                    newRecord.put(this.fieldName(fieldNamePrefix, entry.getKey()), entry.getValue());
                    continue block4;
                }
                case MAP: {
                    Map<String, Object> fieldValue = Requirements.requireMap(entry.getValue(), PURPOSE);
                    this.applySchemaless(fieldValue, fieldName, newRecord);
                    continue block4;
                }
            }
            throw new DataException("Flatten transformation does not support " + entry.getValue().getClass() + " for record without schemas (for field " + fieldName + ").");
        }
    }

    private R applyWithSchema(R record) {
        Struct value = Requirements.requireStructOrNull(this.operatingValue(record), PURPOSE);
        Schema schema = this.operatingSchema(record);
        Schema updatedSchema = this.schemaUpdateCache.get(schema);
        if (updatedSchema == null) {
            SchemaBuilder builder = SchemaUtil.copySchemaBasics(schema, SchemaBuilder.struct());
            Struct defaultValue = (Struct)schema.defaultValue();
            this.buildUpdatedSchema(schema, "", builder, schema.isOptional(), defaultValue);
            updatedSchema = builder.build();
            this.schemaUpdateCache.put(schema, updatedSchema);
        }
        if (value == null) {
            return this.newRecord(record, updatedSchema, null);
        }
        Struct updatedValue = new Struct(updatedSchema);
        this.buildWithSchema(value, "", updatedValue);
        return this.newRecord(record, updatedSchema, updatedValue);
    }

    private void buildUpdatedSchema(Schema schema, String fieldNamePrefix, SchemaBuilder newSchema, boolean optional, Struct defaultFromParent) {
        block4: for (Field field : schema.fields()) {
            String fieldName = this.fieldName(fieldNamePrefix, field.name());
            boolean fieldIsOptional = optional || field.schema().isOptional();
            Object fieldDefaultValue = null;
            if (field.schema().defaultValue() != null) {
                fieldDefaultValue = field.schema().defaultValue();
            } else if (defaultFromParent != null) {
                fieldDefaultValue = defaultFromParent.get(field);
            }
            switch (field.schema().type()) {
                case INT8: 
                case INT16: 
                case INT32: 
                case INT64: 
                case FLOAT32: 
                case FLOAT64: 
                case BOOLEAN: 
                case STRING: 
                case BYTES: {
                    newSchema.field(fieldName, this.convertFieldSchema(field.schema(), fieldIsOptional, fieldDefaultValue));
                    continue block4;
                }
                case STRUCT: {
                    this.buildUpdatedSchema(field.schema(), fieldName, newSchema, fieldIsOptional, (Struct)fieldDefaultValue);
                    continue block4;
                }
            }
            throw new DataException("Flatten transformation does not support " + (Object)((Object)field.schema().type()) + " for record with schemas (for field " + fieldName + ").");
        }
    }

    private Schema convertFieldSchema(Schema orig, boolean optional, Object defaultFromParent) {
        SchemaBuilder builder = SchemaUtil.copySchemaBasics(orig);
        if (optional) {
            builder.optional();
        }
        if (defaultFromParent != null) {
            builder.defaultValue(defaultFromParent);
        }
        return builder.build();
    }

    private void buildWithSchema(Struct record, String fieldNamePrefix, Struct newRecord) {
        if (record == null) {
            return;
        }
        block4: for (Field field : record.schema().fields()) {
            String fieldName = this.fieldName(fieldNamePrefix, field.name());
            switch (field.schema().type()) {
                case INT8: 
                case INT16: 
                case INT32: 
                case INT64: 
                case FLOAT32: 
                case FLOAT64: 
                case BOOLEAN: 
                case STRING: 
                case BYTES: {
                    newRecord.put(fieldName, record.get(field));
                    continue block4;
                }
                case STRUCT: {
                    this.buildWithSchema(record.getStruct(field.name()), fieldName, newRecord);
                    continue block4;
                }
            }
            throw new DataException("Flatten transformation does not support " + (Object)((Object)field.schema().type()) + " for record with schemas (for field " + fieldName + ").");
        }
    }

    private String fieldName(String prefix, String fieldName) {
        return prefix.isEmpty() ? fieldName : prefix + this.delimiter + fieldName;
    }

    public static class Value<R extends ConnectRecord<R>>
    extends Flatten<R> {
        @Override
        protected Schema operatingSchema(R record) {
            return ((ConnectRecord)record).valueSchema();
        }

        @Override
        protected Object operatingValue(R record) {
            return ((ConnectRecord)record).value();
        }

        @Override
        protected R newRecord(R record, Schema updatedSchema, Object updatedValue) {
            return ((ConnectRecord)record).newRecord(((ConnectRecord)record).topic(), ((ConnectRecord)record).kafkaPartition(), ((ConnectRecord)record).keySchema(), ((ConnectRecord)record).key(), updatedSchema, updatedValue, ((ConnectRecord)record).timestamp());
        }
    }

    public static class Key<R extends ConnectRecord<R>>
    extends Flatten<R> {
        @Override
        protected Schema operatingSchema(R record) {
            return ((ConnectRecord)record).keySchema();
        }

        @Override
        protected Object operatingValue(R record) {
            return ((ConnectRecord)record).key();
        }

        @Override
        protected R newRecord(R record, Schema updatedSchema, Object updatedValue) {
            return ((ConnectRecord)record).newRecord(((ConnectRecord)record).topic(), ((ConnectRecord)record).kafkaPartition(), updatedSchema, updatedValue, ((ConnectRecord)record).valueSchema(), ((ConnectRecord)record).value(), ((ConnectRecord)record).timestamp());
        }
    }
}

