/*
 * Decompiled with CFR 0.152.
 */
package com.ctrip.framework.apollo.core.utils;

import com.ctrip.framework.apollo.core.utils.ClassLoaderUtil;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.nio.file.Paths;
import java.util.Map;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ResourceUtils {
    private static final Logger logger = LoggerFactory.getLogger(ResourceUtils.class);
    private static final String[] DEFAULT_FILE_SEARCH_LOCATIONS = new String[]{"./config/", "./"};

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Properties readConfigFile(String configPath, Properties defaults) {
        Properties props = new Properties();
        if (defaults != null) {
            props.putAll((Map<?, ?>)defaults);
        }
        InputStream in = ResourceUtils.loadConfigFileFromDefaultSearchLocations(configPath);
        try {
            if (in != null) {
                props.load(in);
            }
        }
        catch (IOException ex) {
            logger.warn("Reading config failed: {}", (Object)ex.getMessage());
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException ex) {
                    logger.warn("Close config failed: {}", (Object)ex.getMessage());
                }
            }
        }
        if (logger.isDebugEnabled()) {
            StringBuilder sb = new StringBuilder();
            for (String propertyName : props.stringPropertyNames()) {
                sb.append(propertyName).append('=').append(props.getProperty(propertyName)).append('\n');
            }
            if (sb.length() > 0) {
                logger.debug("Reading properties: \n" + sb.toString());
            } else {
                logger.warn("No available properties: {}", (Object)configPath);
            }
        }
        return props;
    }

    private static InputStream loadConfigFileFromDefaultSearchLocations(String configPath) {
        try {
            InputStream in;
            for (String searchLocation : DEFAULT_FILE_SEARCH_LOCATIONS) {
                File candidate = Paths.get(searchLocation, configPath).toFile();
                if (!candidate.exists() || !candidate.isFile() || !candidate.canRead()) continue;
                logger.debug("Reading config from resource {}", (Object)candidate.getAbsolutePath());
                return new FileInputStream(candidate);
            }
            URL url = ClassLoaderUtil.getLoader().getResource(configPath);
            if (url != null && (in = ResourceUtils.getResourceAsStream(url)) != null) {
                logger.debug("Reading config from resource {}", (Object)url.getPath());
                return in;
            }
            File candidate = new File(System.getProperty("user.dir"), configPath);
            if (candidate.exists() && candidate.isFile() && candidate.canRead()) {
                logger.debug("Reading config from resource {}", (Object)candidate.getAbsolutePath());
                return new FileInputStream(candidate);
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
            // empty catch block
        }
        return null;
    }

    private static InputStream getResourceAsStream(URL url) {
        try {
            return url != null ? url.openStream() : null;
        }
        catch (IOException e) {
            return null;
        }
    }
}

