/*
 * Decompiled with CFR 0.152.
 */
package com.ctrip.framework.apollo.core.utils;

import java.net.NetworkInterface;
import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;
import java.security.SecureRandom;
import java.util.Enumeration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MachineUtil {
    private static final Logger logger = LoggerFactory.getLogger(MachineUtil.class);
    private static final int MACHINE_IDENTIFIER = MachineUtil.createMachineIdentifier();

    public static int getMachineIdentifier() {
        return MACHINE_IDENTIFIER;
    }

    private static int createMachineIdentifier() {
        int machinePiece;
        try {
            StringBuilder sb = new StringBuilder();
            Enumeration<NetworkInterface> e = NetworkInterface.getNetworkInterfaces();
            if (e != null) {
                while (e.hasMoreElements()) {
                    NetworkInterface ni = e.nextElement();
                    sb.append(ni.toString());
                    byte[] mac = ni.getHardwareAddress();
                    if (mac == null) continue;
                    ByteBuffer bb = ByteBuffer.wrap(mac);
                    try {
                        sb.append(bb.getChar());
                        sb.append(bb.getChar());
                        sb.append(bb.getChar());
                    }
                    catch (BufferUnderflowException shortHardwareAddressException) {}
                }
            }
            machinePiece = sb.toString().hashCode();
        }
        catch (Throwable ex) {
            machinePiece = new SecureRandom().nextInt();
            logger.warn("Failed to get machine identifier from network interface, using random number instead", ex);
        }
        return machinePiece;
    }
}

