/*
 * Decompiled with CFR 0.152.
 */
package com.diffplug.common.collect;

import com.diffplug.common.base.Converter;
import com.diffplug.common.base.ConverterNullable;
import com.diffplug.common.collect.BiMap;
import com.diffplug.common.collect.HashBiMap;
import com.diffplug.common.collect.ImmutableBiMap;
import com.diffplug.common.collect.ImmutableCollection;
import com.diffplug.common.collect.ImmutableList;
import com.diffplug.common.collect.ImmutableMap;
import com.diffplug.common.collect.ImmutableSet;
import com.diffplug.common.collect.ImmutableSortedMap;
import com.diffplug.common.collect.ImmutableSortedSet;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.NavigableMap;
import java.util.NavigableSet;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.function.BiConsumer;
import java.util.function.BinaryOperator;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.function.UnaryOperator;
import java.util.stream.Collector;

public class Immutables {
    private Immutables() {
    }

    public static <T> ImmutableList<T> mutateList(ImmutableList<T> source, Consumer<List<T>> mutator) {
        ArrayList<T> mutable = new ArrayList<T>(source);
        mutator.accept(mutable);
        return ImmutableList.copyOf(mutable);
    }

    public static <T> ImmutableSet<T> mutateSet(ImmutableSet<T> source, Consumer<Set<T>> mutator) {
        LinkedHashSet<T> mutable = new LinkedHashSet<T>(source);
        mutator.accept(mutable);
        return ImmutableSet.copyOf(mutable);
    }

    public static <K, V> ImmutableMap<K, V> mutateMap(ImmutableMap<K, V> source, Consumer<Map<K, V>> mutator) {
        LinkedHashMap<K, V> mutable = new LinkedHashMap<K, V>(source);
        mutator.accept(mutable);
        return ImmutableMap.copyOf(mutable);
    }

    public static <T> ImmutableSortedSet<T> mutateSortedSet(ImmutableSortedSet<T> source, Consumer<NavigableSet<T>> mutator) {
        TreeSet<T> mutable = new TreeSet<T>(source);
        mutator.accept(mutable);
        return ImmutableSortedSet.copyOfSorted(mutable);
    }

    public static <K, V> ImmutableSortedMap<K, V> mutateSortedMap(ImmutableSortedMap<K, V> source, Consumer<NavigableMap<K, V>> mutator) {
        TreeMap<K, V> mutable = new TreeMap<K, V>(source);
        mutator.accept(mutable);
        return ImmutableSortedMap.copyOfSorted(mutable);
    }

    public static <K, V> ImmutableBiMap<K, V> mutateBiMap(ImmutableBiMap<K, V> source, Consumer<BiMap<K, V>> mutator) {
        HashBiMap<K, V> mutable = HashBiMap.create(source);
        mutator.accept(mutable);
        return ImmutableBiMap.copyOf(mutable);
    }

    public static <T> UnaryOperator<ImmutableList<T>> mutatorList(Consumer<List<T>> mutator) {
        Objects.requireNonNull(mutator);
        return input -> Immutables.mutateList(input, mutator);
    }

    public static <T> UnaryOperator<ImmutableSet<T>> mutatorSet(Consumer<Set<T>> mutator) {
        Objects.requireNonNull(mutator);
        return input -> Immutables.mutateSet(input, mutator);
    }

    public static <K, V> UnaryOperator<ImmutableMap<K, V>> mutatorMap(Consumer<Map<K, V>> mutator) {
        Objects.requireNonNull(mutator);
        return input -> Immutables.mutateMap(input, mutator);
    }

    public static <T> UnaryOperator<ImmutableSortedSet<T>> mutatorSortedSet(Consumer<NavigableSet<T>> mutator) {
        Objects.requireNonNull(mutator);
        return input -> Immutables.mutateSortedSet(input, mutator);
    }

    public static <K, V> UnaryOperator<ImmutableSortedMap<K, V>> mutatorSortedMap(Consumer<NavigableMap<K, V>> mutator) {
        Objects.requireNonNull(mutator);
        return input -> Immutables.mutateSortedMap(input, mutator);
    }

    public static <K, V> UnaryOperator<ImmutableBiMap<K, V>> mutatorBiMap(Consumer<BiMap<K, V>> mutator) {
        Objects.requireNonNull(mutator);
        return input -> Immutables.mutateBiMap(input, mutator);
    }

    public static <T, R> ImmutableList<R> perElementMutateList(ImmutableList<T> source, Function<? super T, ? extends R> mutator) {
        Objects.requireNonNull(mutator);
        ImmutableList.Builder builder = ImmutableList.builder(source.size());
        for (Object element : source) {
            R result = mutator.apply(element);
            if (result == null) continue;
            builder.add(result);
        }
        return builder.build();
    }

    public static <T, R> ImmutableSet<R> perElementMutateSet(ImmutableSet<T> source, Function<? super T, ? extends R> mutator) {
        Objects.requireNonNull(mutator);
        ImmutableSet.Builder builder = ImmutableSet.builder(source.size());
        for (Object element : source) {
            R result = mutator.apply(element);
            if (result == null) continue;
            builder.add(result);
        }
        return builder.build();
    }

    public static <T, R> Converter<Optional<T>, Optional<R>> perElementConverterOpt(ConverterNullable<T, R> perElement) {
        Objects.requireNonNull(perElement);
        return Converter.from(optT -> optT.map(arg_0 -> ((ConverterNullable)perElement).convert(arg_0)), optR -> optR.map(arg_0 -> ((ConverterNullable)perElement).revert(arg_0)), (String)("perElement=" + perElement));
    }

    public static <T, R> Converter<ImmutableSet<T>, ImmutableSet<R>> perElementConverterSet(ConverterNullable<T, R> perElement) {
        Objects.requireNonNull(perElement);
        return Converter.from(setOfT -> Immutables.perElementMutateSet(setOfT, arg_0 -> ((ConverterNullable)perElement).convert(arg_0)), setOfR -> Immutables.perElementMutateSet(setOfR, arg_0 -> ((ConverterNullable)perElement).revert(arg_0)), (String)perElement.toString());
    }

    public static <T, R> Converter<ImmutableList<T>, ImmutableList<R>> perElementConverterList(ConverterNullable<T, R> perElement) {
        Objects.requireNonNull(perElement);
        return Converter.from(setOfT -> Immutables.perElementMutateList(setOfT, arg_0 -> ((ConverterNullable)perElement).convert(arg_0)), setOfR -> Immutables.perElementMutateList(setOfR, arg_0 -> ((ConverterNullable)perElement).revert(arg_0)), (String)perElement.toString());
    }

    public static <T> ImmutableSet<T> optionalToSet(Optional<T> selection) {
        if (selection.isPresent()) {
            return ImmutableSet.of(selection.get());
        }
        return ImmutableSet.of();
    }

    public static <T> Optional<T> optionalFrom(ImmutableCollection<T> collection) {
        switch (collection.size()) {
            case 0: {
                return Optional.empty();
            }
            case 1: {
                return Optional.of(collection.iterator().next());
            }
        }
        throw new IllegalArgumentException("Collection contains multiple elements:" + collection);
    }

    public static <T> Collector<T, ?, ImmutableList<T>> toList() {
        return Immutables.toList(4);
    }

    public static <T> Collector<T, ?, ImmutableList<T>> toList(int initialCapacity) {
        Supplier<ImmutableList.Builder> supplier = () -> ImmutableList.builder(initialCapacity);
        BiConsumer<ImmutableList.Builder, Object> accumulator = ImmutableList.Builder::add;
        BinaryOperator combiner = (l, r) -> l.addAll((Iterable)r.build());
        Function<ImmutableList.Builder, ImmutableList> finisher = ImmutableList.Builder::build;
        return Collector.of(supplier, accumulator, combiner, finisher, new Collector.Characteristics[0]);
    }

    public static <T> Collector<T, ?, ImmutableSet<T>> toSet() {
        return Immutables.toSet(4);
    }

    public static <T> Collector<T, ?, ImmutableSet<T>> toSet(int initialCapacity) {
        Supplier<ImmutableSet.Builder> supplier = () -> ImmutableSet.builder(initialCapacity);
        BiConsumer<ImmutableSet.Builder, Object> accumulator = ImmutableSet.Builder::add;
        BinaryOperator combiner = (l, r) -> l.addAll((Iterable)r.build());
        Function<ImmutableSet.Builder, ImmutableSet> finisher = ImmutableSet.Builder::build;
        return Collector.of(supplier, accumulator, combiner, finisher, new Collector.Characteristics[0]);
    }

    public static <T, K, V> Collector<T, ?, ImmutableMap<K, V>> toMap(Function<? super T, ? extends K> keyMapper, Function<? super T, ? extends V> valueMapper) {
        return Immutables.toMap(4, keyMapper, valueMapper);
    }

    public static <T, K, V> Collector<T, ?, ImmutableMap<K, V>> toMap(int initialCapacity, Function<? super T, ? extends K> keyMapper, Function<? super T, ? extends V> valueMapper) {
        Objects.requireNonNull(keyMapper);
        Objects.requireNonNull(valueMapper);
        Supplier<ImmutableMap.Builder> supplier = () -> ImmutableMap.builder(initialCapacity);
        BiConsumer<ImmutableMap.Builder, Object> accumulator = (b, v) -> b.put(keyMapper.apply(v), valueMapper.apply(v));
        BinaryOperator combiner = (l, r) -> l.putAll(r.build());
        Function<ImmutableMap.Builder, ImmutableMap> finisher = ImmutableMap.Builder::build;
        return Collector.of(supplier, accumulator, combiner, finisher, new Collector.Characteristics[0]);
    }

    public static <T> Collector<T, ?, ImmutableSortedSet<T>> toSortedSet(Comparator<? super T> comparator) {
        return Immutables.toSortedSet(4, comparator);
    }

    public static <T> Collector<T, ?, ImmutableSortedSet<T>> toSortedSet(int initialCapacity, Comparator<? super T> comparator) {
        Objects.requireNonNull(comparator);
        Supplier<ImmutableSortedSet.Builder> supplier = () -> new ImmutableSortedSet.Builder(initialCapacity, comparator);
        BiConsumer<ImmutableSortedSet.Builder, Object> accumulator = ImmutableSortedSet.Builder::add;
        BinaryOperator combiner = (l, r) -> l.addAll((Iterable)r.build());
        Function<ImmutableSortedSet.Builder, ImmutableSortedSet> finisher = ImmutableSortedSet.Builder::build;
        return Collector.of(supplier, accumulator, combiner, finisher, new Collector.Characteristics[0]);
    }

    public static <T, K extends Comparable<?>, V> Collector<T, ?, ImmutableSortedMap<K, V>> toSortedMap(Comparator<? super K> comparator, Function<? super T, ? extends K> keyMapper, Function<? super T, ? extends V> valueMapper) {
        return Immutables.toSortedMap(4, comparator, keyMapper, valueMapper);
    }

    public static <T, K extends Comparable<?>, V> Collector<T, ?, ImmutableSortedMap<K, V>> toSortedMap(int initialCapacity, Comparator<? super K> comparator, Function<? super T, ? extends K> keyMapper, Function<? super T, ? extends V> valueMapper) {
        Objects.requireNonNull(comparator);
        Objects.requireNonNull(keyMapper);
        Objects.requireNonNull(valueMapper);
        Supplier<ImmutableSortedMap.Builder> supplier = () -> new ImmutableSortedMap.Builder(initialCapacity, comparator);
        BiConsumer<ImmutableSortedMap.Builder, Object> accumulator = (b, v) -> b.put(keyMapper.apply(v), valueMapper.apply(v));
        BinaryOperator combiner = (l, r) -> l.putAll((Map)r.build());
        Function<ImmutableSortedMap.Builder, ImmutableSortedMap> finisher = ImmutableSortedMap.Builder::build;
        return Collector.of(supplier, accumulator, combiner, finisher, new Collector.Characteristics[0]);
    }

    public static <T, K, V> Collector<T, ?, ImmutableBiMap<K, V>> toBiMap(Function<? super T, ? extends K> keyMapper, Function<? super T, ? extends V> valueMapper) {
        return Immutables.toBiMap(4, keyMapper, valueMapper);
    }

    public static <T, K, V> Collector<T, ?, ImmutableBiMap<K, V>> toBiMap(int initialCapacity, Function<? super T, ? extends K> keyMapper, Function<? super T, ? extends V> valueMapper) {
        Objects.requireNonNull(keyMapper);
        Objects.requireNonNull(valueMapper);
        Supplier<ImmutableBiMap.Builder> supplier = () -> ImmutableBiMap.builder(initialCapacity);
        BiConsumer<ImmutableBiMap.Builder, Object> accumulator = (b, v) -> b.put(keyMapper.apply(v), valueMapper.apply(v));
        BinaryOperator combiner = (l, r) -> l.putAll((Map)r.build());
        Function<ImmutableBiMap.Builder, ImmutableBiMap> finisher = ImmutableBiMap.Builder::build;
        return Collector.of(supplier, accumulator, combiner, finisher, new Collector.Characteristics[0]);
    }
}

