/*
 * Decompiled with CFR 0.152.
 */
package weixin.popular.util;

import com.qq.weixin.mp.aes.PKCS7Encoder;
import java.security.Key;
import javax.crypto.Cipher;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.codec.digest.DigestUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import weixin.popular.bean.wxa.WxaDUserInfo;
import weixin.popular.bean.wxa.WxaUserInfo;
import weixin.popular.util.JsonUtil;

public abstract class WxaUtil {
    private static Logger logger = LoggerFactory.getLogger(WxaUtil.class);

    public static WxaDUserInfo decryptUserInfo(String session_key, String encryptedData, String iv) {
        try {
            Cipher cipher = Cipher.getInstance("AES/CBC/NoPadding");
            SecretKeySpec sKeySpec = new SecretKeySpec(Base64.decodeBase64((String)session_key), "AES");
            cipher.init(2, (Key)sKeySpec, new IvParameterSpec(Base64.decodeBase64((String)iv)));
            byte[] resultByte = cipher.doFinal(Base64.decodeBase64((String)encryptedData));
            String data = new String(PKCS7Encoder.decode(resultByte));
            return JsonUtil.parseObject(data, WxaDUserInfo.class);
        }
        catch (Exception e) {
            logger.error("", (Throwable)e);
            return null;
        }
    }

    public static WxaUserInfo validateUserInfo(String session_key, String rawData, String signature) {
        try {
            if (DigestUtils.shaHex((String)(rawData + session_key)).equals(signature)) {
                return JsonUtil.parseObject(rawData, WxaUserInfo.class);
            }
        }
        catch (Exception e) {
            logger.error("", (Throwable)e);
        }
        return null;
    }
}

