/*
 * Decompiled with CFR 0.152.
 */
package com.github.pagehelper.parser;

import com.github.pagehelper.JSqlParser;
import com.github.pagehelper.page.PageMethod;
import com.github.pagehelper.parser.CountSqlParser;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.sf.jsqlparser.expression.Alias;
import net.sf.jsqlparser.expression.Expression;
import net.sf.jsqlparser.expression.Function;
import net.sf.jsqlparser.expression.Parenthesis;
import net.sf.jsqlparser.parser.Token;
import net.sf.jsqlparser.schema.Column;
import net.sf.jsqlparser.statement.Statement;
import net.sf.jsqlparser.statement.select.FromItem;
import net.sf.jsqlparser.statement.select.Join;
import net.sf.jsqlparser.statement.select.LateralSubSelect;
import net.sf.jsqlparser.statement.select.OrderByElement;
import net.sf.jsqlparser.statement.select.PlainSelect;
import net.sf.jsqlparser.statement.select.Select;
import net.sf.jsqlparser.statement.select.SelectBody;
import net.sf.jsqlparser.statement.select.SelectExpressionItem;
import net.sf.jsqlparser.statement.select.SelectItem;
import net.sf.jsqlparser.statement.select.SetOperationList;
import net.sf.jsqlparser.statement.select.SubJoin;
import net.sf.jsqlparser.statement.select.SubSelect;
import net.sf.jsqlparser.statement.select.ValuesList;
import net.sf.jsqlparser.statement.select.WithItem;

public class DefaultCountSqlParser
implements CountSqlParser {
    public static final String KEEP_ORDERBY = "/*keep orderby*/";
    protected static final Alias TABLE_ALIAS = new Alias("table_count");
    protected final Set<String> skipFunctions = Collections.synchronizedSet(new HashSet());
    protected final Set<String> falseFunctions = Collections.synchronizedSet(new HashSet());
    protected final JSqlParser jSqlParser;

    public DefaultCountSqlParser() {
        this.jSqlParser = JSqlParser.DEFAULT;
    }

    public DefaultCountSqlParser(JSqlParser jSqlParser) {
        this.jSqlParser = jSqlParser;
    }

    @Override
    public String getSmartCountSql(String sql, String countColumn) {
        String hints;
        Token token;
        Statement stmt = null;
        if (sql.indexOf(KEEP_ORDERBY) >= 0 || this.keepOrderBy()) {
            return this.getSimpleCountSql(sql, countColumn);
        }
        try {
            stmt = this.jSqlParser.parse(sql);
        }
        catch (Throwable e) {
            return this.getSimpleCountSql(sql, countColumn);
        }
        Select select = (Select)stmt;
        SelectBody selectBody = select.getSelectBody();
        try {
            this.processSelectBody(selectBody);
        }
        catch (Exception e) {
            return this.getSimpleCountSql(sql, countColumn);
        }
        this.processWithItemsList(select.getWithItemsList());
        this.sqlToCount(select, countColumn);
        String result = select.toString();
        if (selectBody instanceof PlainSelect && (token = ((PlainSelect)selectBody).getASTNode().jjtGetFirstToken().specialToken) != null && (hints = token.toString().trim()).startsWith("/*") && hints.endsWith("*/") && !result.startsWith("/*")) {
            result = hints + result;
        }
        return result;
    }

    public String getSimpleCountSql(String sql) {
        return this.getSimpleCountSql(sql, "0");
    }

    public String getSimpleCountSql(String sql, String name) {
        StringBuilder stringBuilder = new StringBuilder(sql.length() + 40);
        stringBuilder.append("select count(");
        stringBuilder.append(name);
        stringBuilder.append(") from ( \n");
        stringBuilder.append(sql);
        stringBuilder.append("\n ) tmp_count");
        return stringBuilder.toString();
    }

    public void sqlToCount(Select select, String name) {
        SelectBody selectBody = select.getSelectBody();
        ArrayList<SelectExpressionItem> COUNT_ITEM = new ArrayList<SelectExpressionItem>();
        COUNT_ITEM.add(new SelectExpressionItem((Expression)new Column("count(" + name + ")")));
        if (selectBody instanceof PlainSelect && this.isSimpleCount((PlainSelect)selectBody)) {
            ((PlainSelect)selectBody).setSelectItems(COUNT_ITEM);
        } else {
            PlainSelect plainSelect = new PlainSelect();
            SubSelect subSelect = new SubSelect();
            subSelect.setSelectBody(selectBody);
            subSelect.setAlias(TABLE_ALIAS);
            plainSelect.setFromItem((FromItem)subSelect);
            plainSelect.setSelectItems(COUNT_ITEM);
            select.setSelectBody((SelectBody)plainSelect);
        }
    }

    public boolean isSimpleCount(PlainSelect select) {
        if (select.getGroupBy() != null) {
            return false;
        }
        if (select.getDistinct() != null) {
            return false;
        }
        if (select.getHaving() != null) {
            return false;
        }
        for (SelectItem item : select.getSelectItems()) {
            if (item.toString().contains("?")) {
                return false;
            }
            if (!(item instanceof SelectExpressionItem)) continue;
            Expression expression = ((SelectExpressionItem)item).getExpression();
            if (expression instanceof Function) {
                String NAME;
                String name = ((Function)expression).getName();
                if (name == null || this.skipFunctions.contains(NAME = name.toUpperCase())) continue;
                if (this.falseFunctions.contains(NAME)) {
                    return false;
                }
                for (String aggregateFunction : AGGREGATE_FUNCTIONS) {
                    if (!NAME.startsWith(aggregateFunction)) continue;
                    this.falseFunctions.add(NAME);
                    return false;
                }
                this.skipFunctions.add(NAME);
                continue;
            }
            if (!(expression instanceof Parenthesis) || ((SelectExpressionItem)item).getAlias() == null) continue;
            return false;
        }
        return true;
    }

    public void processSelectBody(SelectBody selectBody) {
        if (selectBody != null) {
            if (selectBody instanceof PlainSelect) {
                this.processPlainSelect((PlainSelect)selectBody);
            } else if (selectBody instanceof WithItem) {
                WithItem withItem = (WithItem)selectBody;
                if (withItem.getSubSelect() != null && !this.keepSubSelectOrderBy()) {
                    this.processSelectBody(withItem.getSubSelect().getSelectBody());
                }
            } else {
                SetOperationList operationList = (SetOperationList)selectBody;
                if (operationList.getSelects() != null && operationList.getSelects().size() > 0) {
                    List plainSelects = operationList.getSelects();
                    for (SelectBody plainSelect : plainSelects) {
                        this.processSelectBody(plainSelect);
                    }
                }
                if (!this.orderByHashParameters(operationList.getOrderByElements())) {
                    operationList.setOrderByElements(null);
                }
            }
        }
    }

    public void processPlainSelect(PlainSelect plainSelect) {
        if (!this.orderByHashParameters(plainSelect.getOrderByElements())) {
            plainSelect.setOrderByElements(null);
        }
        if (plainSelect.getFromItem() != null) {
            this.processFromItem(plainSelect.getFromItem());
        }
        if (plainSelect.getJoins() != null && plainSelect.getJoins().size() > 0) {
            List joins = plainSelect.getJoins();
            for (Join join : joins) {
                if (join.getRightItem() == null) continue;
                this.processFromItem(join.getRightItem());
            }
        }
    }

    public void processWithItemsList(List<WithItem> withItemsList) {
        if (withItemsList != null && withItemsList.size() > 0) {
            for (WithItem item : withItemsList) {
                if (item.getSubSelect() == null || this.keepSubSelectOrderBy()) continue;
                this.processSelectBody(item.getSubSelect().getSelectBody());
            }
        }
    }

    public void processFromItem(FromItem fromItem) {
        SubSelect subSelect;
        LateralSubSelect lateralSubSelect;
        if (fromItem instanceof SubJoin) {
            SubJoin subJoin = (SubJoin)fromItem;
            if (subJoin.getJoinList() != null && subJoin.getJoinList().size() > 0) {
                for (Join join : subJoin.getJoinList()) {
                    if (join.getRightItem() == null) continue;
                    this.processFromItem(join.getRightItem());
                }
            }
            if (subJoin.getLeft() != null) {
                this.processFromItem(subJoin.getLeft());
            }
        } else if (fromItem instanceof SubSelect) {
            SubSelect subSelect2 = (SubSelect)fromItem;
            if (subSelect2.getSelectBody() != null && !this.keepSubSelectOrderBy()) {
                this.processSelectBody(subSelect2.getSelectBody());
            }
        } else if (!(fromItem instanceof ValuesList) && fromItem instanceof LateralSubSelect && (lateralSubSelect = (LateralSubSelect)fromItem).getSubSelect() != null && (subSelect = lateralSubSelect.getSubSelect()).getSelectBody() != null && !this.keepSubSelectOrderBy()) {
            this.processSelectBody(subSelect.getSelectBody());
        }
    }

    protected boolean keepOrderBy() {
        return PageMethod.getLocalPage() != null && PageMethod.getLocalPage().keepOrderBy();
    }

    protected boolean keepSubSelectOrderBy() {
        return PageMethod.getLocalPage() != null && PageMethod.getLocalPage().keepSubSelectOrderBy();
    }

    public boolean orderByHashParameters(List<OrderByElement> orderByElements) {
        if (orderByElements == null) {
            return false;
        }
        for (OrderByElement orderByElement : orderByElements) {
            if (!orderByElement.toString().contains("?")) continue;
            return true;
        }
        return false;
    }

    static {
        TABLE_ALIAS.setUseAs(false);
    }
}

