/*
 * Decompiled with CFR 0.152.
 */
package com.github.pagehelper.dialect;

import com.github.pagehelper.Dialect;
import com.github.pagehelper.JSqlParser;
import com.github.pagehelper.PageException;
import com.github.pagehelper.PageProperties;
import com.github.pagehelper.parser.CountSqlParser;
import com.github.pagehelper.parser.DefaultCountSqlParser;
import com.github.pagehelper.util.ClassUtil;
import com.github.pagehelper.util.StringUtil;
import java.lang.reflect.Constructor;
import java.util.Properties;
import org.apache.ibatis.cache.CacheKey;
import org.apache.ibatis.mapping.BoundSql;
import org.apache.ibatis.mapping.MappedStatement;
import org.apache.ibatis.session.RowBounds;

public abstract class AbstractDialect
implements Dialect {
    protected CountSqlParser countSqlParser;
    protected JSqlParser jSqlParser;

    @Override
    public String getCountSql(MappedStatement ms, BoundSql boundSql, Object parameterObject, RowBounds rowBounds, CacheKey countKey) {
        return this.countSqlParser.getSmartCountSql(boundSql.getSql());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void setProperties(Properties properties) {
        String sqlParser = properties.getProperty("sqlParser");
        this.jSqlParser = StringUtil.isNotEmpty(sqlParser) ? (JSqlParser)ClassUtil.newInstance(sqlParser, properties) : JSqlParser.DEFAULT;
        String countSqlParserStr = properties.getProperty("countSqlParser");
        if (StringUtil.isNotEmpty(countSqlParserStr)) {
            try {
                Class<?> aClass = Class.forName(countSqlParserStr);
                Constructor<?> constructor = null;
                try {
                    constructor = aClass.getConstructor(JSqlParser.class);
                    this.countSqlParser = (CountSqlParser)constructor.newInstance(this.jSqlParser);
                }
                catch (NoSuchMethodException e) {
                    this.countSqlParser = (CountSqlParser)aClass.newInstance();
                }
                if (!(this.countSqlParser instanceof PageProperties)) return;
                ((PageProperties)((Object)this.countSqlParser)).setProperties(properties);
                return;
            }
            catch (Exception e) {
                throw new PageException(e);
            }
        }
        this.countSqlParser = new DefaultCountSqlParser(this.jSqlParser);
    }
}

