/*
 * Decompiled with CFR 0.152.
 */
package com.github.pagehelper.parser;

import com.github.pagehelper.JSqlParser;
import com.github.pagehelper.PageException;
import java.util.List;
import net.sf.jsqlparser.statement.Statement;
import net.sf.jsqlparser.statement.select.OrderByElement;
import net.sf.jsqlparser.statement.select.PlainSelect;
import net.sf.jsqlparser.statement.select.Select;
import net.sf.jsqlparser.statement.select.SelectBody;
import net.sf.jsqlparser.statement.select.SetOperationList;
import net.sf.jsqlparser.statement.select.WithItem;
import org.apache.ibatis.logging.Log;
import org.apache.ibatis.logging.LogFactory;

public class OrderByParser {
    private static final Log log = LogFactory.getLog(OrderByParser.class);

    public static String converToOrderBySql(String sql, String orderBy, JSqlParser jSqlParser) {
        Statement stmt = null;
        try {
            stmt = jSqlParser.parse(sql);
            Select select = (Select)stmt;
            SelectBody selectBody = select.getSelectBody();
            List<OrderByElement> orderByElements = OrderByParser.extraOrderBy(selectBody);
            String defaultOrderBy = PlainSelect.orderByToString(orderByElements);
            if (defaultOrderBy.indexOf(63) != -1) {
                throw new PageException("The order by in the original SQL[" + sql + "] contains parameters, so it cannot be modified using the OrderBy plugin!");
            }
            sql = select.toString();
        }
        catch (Throwable e) {
            log.warn("Failed to handle sorting: " + e + ", downgraded to a direct splice of the order by parameter");
        }
        return sql + " order by " + orderBy;
    }

    public static String converToOrderBySql(String sql, String orderBy) {
        return OrderByParser.converToOrderBySql(sql, orderBy, JSqlParser.DEFAULT);
    }

    public static List<OrderByElement> extraOrderBy(SelectBody selectBody) {
        if (selectBody != null) {
            if (selectBody instanceof PlainSelect) {
                List orderByElements = ((PlainSelect)selectBody).getOrderByElements();
                ((PlainSelect)selectBody).setOrderByElements(null);
                return orderByElements;
            }
            if (selectBody instanceof WithItem) {
                WithItem withItem = (WithItem)selectBody;
                if (withItem.getSubSelect() != null) {
                    return OrderByParser.extraOrderBy(withItem.getSubSelect().getSelectBody());
                }
            } else {
                SetOperationList operationList = (SetOperationList)selectBody;
                if (operationList.getSelects() != null && operationList.getSelects().size() > 0) {
                    List plainSelects = operationList.getSelects();
                    return OrderByParser.extraOrderBy((SelectBody)plainSelects.get(plainSelects.size() - 1));
                }
            }
        }
        return null;
    }
}

