/*
 * Decompiled with CFR 0.152.
 */
package com.github.zuihou.base.controller;

import com.github.zuihou.base.R;
import com.github.zuihou.base.service.SuperService;
import com.github.zuihou.context.BaseContextHandler;
import com.github.zuihou.exception.BizException;
import com.github.zuihou.exception.code.BaseExceptionCode;

public interface BaseController<Entity> {
    public Class<Entity> getEntityClass();

    public SuperService<Entity> getBaseService();

    default public <T> R<T> success(T data) {
        return R.success(data);
    }

    default public R<Boolean> success() {
        return R.success();
    }

    default public <T> R<T> fail(String msg) {
        return R.fail((String)msg);
    }

    default public <T> R<T> fail(String msg, Object ... args) {
        return R.fail((String)msg, (Object[])args);
    }

    default public <T> R<T> fail(int code, String msg) {
        return R.fail((int)code, (String)msg);
    }

    default public <T> R<T> fail(BaseExceptionCode exceptionCode) {
        return R.fail((BaseExceptionCode)exceptionCode);
    }

    default public <T> R<T> fail(BizException exception) {
        return R.fail((BizException)exception);
    }

    default public <T> R<T> fail(Throwable throwable) {
        return R.fail((Throwable)throwable);
    }

    default public <T> R<T> validFail(String msg) {
        return R.validFail((String)msg);
    }

    default public <T> R<T> validFail(String msg, Object ... args) {
        return R.validFail((String)msg, (Object[])args);
    }

    default public <T> R<T> validFail(BaseExceptionCode exceptionCode) {
        return R.validFail((BaseExceptionCode)exceptionCode);
    }

    default public Long getUserId() {
        return BaseContextHandler.getUserId();
    }

    default public String getTenant() {
        return BaseContextHandler.getTenant();
    }

    default public String getAccount() {
        return BaseContextHandler.getAccount();
    }

    default public String getName() {
        return BaseContextHandler.getName();
    }
}

