/*
 * Decompiled with CFR 0.152.
 */
package com.github.zuihou.base.controller;

import cn.afterturn.easypoi.excel.ExcelExportUtil;
import cn.afterturn.easypoi.excel.ExcelImportUtil;
import cn.afterturn.easypoi.excel.ExcelXorHtmlUtil;
import cn.afterturn.easypoi.excel.entity.ExcelToHtmlParams;
import cn.afterturn.easypoi.excel.entity.ExportParams;
import cn.afterturn.easypoi.excel.entity.ImportParams;
import cn.afterturn.easypoi.excel.entity.enmus.ExcelType;
import cn.afterturn.easypoi.view.PoiBaseView;
import cn.hutool.core.convert.Convert;
import cn.hutool.core.util.StrUtil;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.github.zuihou.base.R;
import com.github.zuihou.base.controller.PageController;
import com.github.zuihou.base.request.PageParams;
import com.github.zuihou.log.annotation.SysLog;
import com.github.zuihou.security.annotation.PreAuth;
import io.swagger.annotations.ApiOperation;
import java.io.InputStream;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.poi.ss.usermodel.Workbook;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.multipart.MultipartFile;

public interface PoiController<Entity, PageDTO>
extends PageController<Entity, PageDTO> {
    @ApiOperation(value="\u5bfc\u51faExcel")
    @RequestMapping(value={"/export"}, method={RequestMethod.POST}, produces={"application/octet-stream"})
    @SysLog(value="'\u5bfc\u51faExcel:'.concat(#params.map[fileName]?:'')")
    @PreAuth(value="hasPermit('{}export')")
    default public void exportExcel(@RequestBody @Validated PageParams<PageDTO> params, HttpServletRequest request, HttpServletResponse response) {
        IPage page = params.buildPage();
        ExportParams exportParams = this.getExportParams(params, page);
        HashMap<String, Object> map = new HashMap<String, Object>(5);
        map.put("data", page.getRecords());
        map.put("entity", this.getEntityClass());
        map.put("params", exportParams);
        String fileName = params.getMap().getOrDefault("fileName", "\u4e34\u65f6\u6587\u4ef6");
        map.put("fileName", fileName);
        PoiBaseView.render(map, (HttpServletRequest)request, (HttpServletResponse)response, (String)"easypoiExcelView");
    }

    @ApiOperation(value="\u9884\u89c8Excel")
    @SysLog(value="'\u9884\u89c8Excel:' + (#params.map[fileName]?:'')")
    @RequestMapping(value={"/preview"}, method={RequestMethod.POST})
    @PreAuth(value="hasPermit('{}export')")
    default public R<String> preview(@RequestBody @Validated PageParams<PageDTO> params) {
        IPage page = params.buildPage();
        ExportParams exportParams = this.getExportParams(params, page);
        Workbook workbook = ExcelExportUtil.exportExcel((ExportParams)exportParams, this.getEntityClass(), (Collection)page.getRecords());
        return this.success(ExcelXorHtmlUtil.excelToHtml((ExcelToHtmlParams)new ExcelToHtmlParams(workbook)));
    }

    @ApiOperation(value="\u5bfc\u5165Excel")
    @PostMapping(value={"/import"})
    @SysLog(value="'\u5bfc\u5165Excel:' + #simpleFile?.originalFilename", request=false)
    @PreAuth(value="hasPermit('{}import')")
    default public R<Boolean> importExcel(@RequestParam(value="file") MultipartFile simpleFile, HttpServletRequest request, HttpServletResponse response) throws Exception {
        ImportParams params = new ImportParams();
        params.setTitleRows(StrUtil.isEmpty((CharSequence)request.getParameter("titleRows")) ? 0 : Convert.toInt((Object)request.getParameter("titleRows")));
        params.setHeadRows(StrUtil.isEmpty((CharSequence)request.getParameter("headRows")) ? 1 : Convert.toInt((Object)request.getParameter("headRows")));
        List list = ExcelImportUtil.importExcel((InputStream)simpleFile.getInputStream(), Map.class, (ImportParams)params);
        if (list != null && !list.isEmpty()) {
            return this.handlerImport(list);
        }
        return this.validFail("\u5bfc\u5165Excel\u65e0\u6709\u6548\u6570\u636e\uff01");
    }

    default public R<Boolean> handlerImport(List<Map<String, String>> list) {
        return R.successDef(null, (String)"\u8bf7\u5728\u5b50\u7c7bController\u91cd\u5199\u5bfc\u5165\u65b9\u6cd5\uff0c\u5b9e\u73b0\u5bfc\u5165\u903b\u8f91");
    }

    default public ExportParams getExportParams(PageParams<PageDTO> params, IPage<Entity> page) {
        this.query(params, page, params.getSize() == -1L ? Convert.toLong((Object)Integer.MAX_VALUE).longValue() : params.getSize());
        String title = params.getMap().get("title");
        String type = params.getMap().getOrDefault("type", ExcelType.XSSF.name());
        String sheetName = params.getMap().getOrDefault("sheetName", "SheetName");
        ExcelType excelType = ExcelType.XSSF.name().equals(type) ? ExcelType.XSSF : ExcelType.HSSF;
        return new ExportParams(title, sheetName, excelType);
    }
}

