/*
 * Decompiled with CFR 0.152.
 */
package com.github.zuihou.base.controller;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.github.zuihou.base.R;
import com.github.zuihou.base.controller.PageController;
import com.github.zuihou.base.request.PageParams;
import com.github.zuihou.database.mybatis.conditions.Wraps;
import com.github.zuihou.database.mybatis.conditions.query.QueryWrap;
import com.github.zuihou.log.annotation.SysLog;
import com.github.zuihou.security.annotation.PreAuth;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import java.io.Serializable;
import java.util.List;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;

public interface QueryController<Entity, Id extends Serializable, PageDTO>
extends PageController<Entity, PageDTO> {
    @ApiImplicitParams(value={@ApiImplicitParam(name="id", value="\u4e3b\u952e", dataType="long", paramType="query")})
    @ApiOperation(value="\u67e5\u8be2", notes="\u67e5\u8be2")
    @GetMapping(value={"/{id}"})
    @SysLog(value="'\u67e5\u8be2:' + #id")
    @PreAuth(value="hasPermit('{}view')")
    default public R<Entity> get(@PathVariable Id id) {
        return this.success(this.getBaseService().getById((Serializable)id));
    }

    @ApiOperation(value="\u5206\u9875\u5217\u8868\u67e5\u8be2")
    @PostMapping(value={"/page"})
    @SysLog(value="'\u5206\u9875\u5217\u8868\u67e5\u8be2:\u7b2c' + #params?.current + '\u9875, \u663e\u793a' + #params?.size + '\u884c'", response=false)
    @PreAuth(value="hasPermit('{}view')")
    default public R<IPage<Entity>> page(@RequestBody @Validated PageParams<PageDTO> params) {
        IPage page = params.buildPage();
        this.query(params, page, null);
        return this.success(page);
    }

    @ApiOperation(value="\u6279\u91cf\u67e5\u8be2", notes="\u6279\u91cf\u67e5\u8be2")
    @PostMapping(value={"/query"})
    @SysLog(value="\u6279\u91cf\u67e5\u8be2")
    @PreAuth(value="hasPermit('{}view')")
    default public R<List<Entity>> query(@RequestBody Entity data) {
        QueryWrap wrapper = Wraps.q(data);
        return this.success(this.getBaseService().list((Wrapper)wrapper));
    }
}

