/*
 * Decompiled with CFR 0.152.
 */
package com.github.zuihou.base.service;

import cn.hutool.core.collection.CollUtil;
import com.baomidou.mybatisplus.core.enums.SqlMethod;
import com.baomidou.mybatisplus.core.metadata.TableInfo;
import com.baomidou.mybatisplus.core.metadata.TableInfoHelper;
import com.baomidou.mybatisplus.core.toolkit.Assert;
import com.baomidou.mybatisplus.core.toolkit.ReflectionKit;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.github.zuihou.base.entity.SuperEntity;
import com.github.zuihou.base.mapper.SuperMapper;
import com.github.zuihou.base.service.SuperCacheService;
import com.github.zuihou.base.service.SuperServiceImpl;
import java.io.Serializable;
import java.util.Collection;
import java.util.Objects;
import net.oschina.j2cache.CacheChannel;
import net.oschina.j2cache.CacheObject;
import org.apache.ibatis.binding.MapperMethod;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.annotation.Transactional;

public abstract class SuperCacheServiceImpl<M extends SuperMapper<T>, T>
extends SuperServiceImpl<M, T>
implements SuperCacheService<T> {
    @Autowired
    protected CacheChannel cacheChannel;

    protected abstract String getRegion();

    @Override
    public T getByIdCache(Serializable id) {
        String key = this.key(id);
        CacheObject cacheObject = this.cacheChannel.get(this.getRegion(), key, x -> super.getById(id), new boolean[0]);
        return (T)cacheObject.getValue();
    }

    @Transactional(rollbackFor={Exception.class})
    public boolean removeById(Serializable id) {
        boolean bool = super.removeById(id);
        String key = this.key(id);
        this.cacheChannel.evict(this.getRegion(), new String[]{key});
        return bool;
    }

    @Transactional(rollbackFor={Exception.class})
    public boolean removeByIds(Collection<? extends Serializable> idList) {
        if (CollUtil.isEmpty(idList)) {
            return true;
        }
        boolean flag = super.removeByIds(idList);
        String[] keys = (String[])idList.stream().map(id -> this.key(id)).toArray(String[]::new);
        this.cacheChannel.evict(this.getRegion(), keys);
        return flag;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public boolean save(T model) {
        boolean save = super.save(model);
        if (model instanceof SuperEntity) {
            String key = this.key(((SuperEntity)model).getId());
            this.cacheChannel.set(this.getRegion(), key, model);
        }
        return save;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public boolean updateAllById(T model) {
        boolean updateBool = super.updateAllById(model);
        if (model instanceof SuperEntity) {
            String key = this.key(((SuperEntity)model).getId());
            this.cacheChannel.evict(this.getRegion(), new String[]{key});
        }
        return updateBool;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public boolean updateById(T model) {
        boolean updateBool = super.updateById(model);
        if (model instanceof SuperEntity) {
            String key = this.key(((SuperEntity)model).getId());
            this.cacheChannel.evict(this.getRegion(), new String[]{key});
        }
        return updateBool;
    }

    @Transactional(rollbackFor={Exception.class})
    public boolean saveBatch(Collection<T> entityList, int batchSize) {
        String sqlStatement = this.sqlStatement(SqlMethod.INSERT_ONE);
        return this.executeBatch(entityList, batchSize, (sqlSession, entity) -> {
            sqlSession.insert(sqlStatement, entity);
            if (entity instanceof SuperEntity) {
                String key = this.key(((SuperEntity)entity).getId());
                this.cacheChannel.set(this.getRegion(), key, entity);
            }
        });
    }

    @Transactional(rollbackFor={Exception.class})
    public boolean saveOrUpdateBatch(Collection<T> entityList, int batchSize) {
        TableInfo tableInfo = TableInfoHelper.getTableInfo((Class)this.entityClass);
        Assert.notNull((Object)tableInfo, (String)"error: can not execute. because can not find cache of TableInfo for entity!", (Object[])new Object[0]);
        String keyProperty = tableInfo.getKeyProperty();
        Assert.notEmpty((String)keyProperty, (String)"error: can not execute. because can not find column for id from entity!", (Object[])new Object[0]);
        return this.executeBatch(entityList, batchSize, (sqlSession, entity) -> {
            Object idVal = ReflectionKit.getMethodValue((Class)this.entityClass, (Object)entity, (String)keyProperty);
            if (StringUtils.checkValNull((Object)idVal) || Objects.isNull(this.getById((Serializable)idVal))) {
                sqlSession.insert(tableInfo.getSqlStatement(SqlMethod.INSERT_ONE.getMethod()), entity);
                if (entity instanceof SuperEntity) {
                    String key = this.key(((SuperEntity)entity).getId());
                    this.cacheChannel.set(this.getRegion(), key, entity);
                }
            } else {
                MapperMethod.ParamMap param = new MapperMethod.ParamMap();
                param.put((Object)"et", entity);
                sqlSession.update(tableInfo.getSqlStatement(SqlMethod.UPDATE_BY_ID.getMethod()), (Object)param);
                if (entity instanceof SuperEntity) {
                    String key = this.key(((SuperEntity)entity).getId());
                    this.cacheChannel.evict(this.getRegion(), new String[]{key});
                }
            }
        });
    }

    @Transactional(rollbackFor={Exception.class})
    public boolean updateBatchById(Collection<T> entityList, int batchSize) {
        String sqlStatement = this.sqlStatement(SqlMethod.UPDATE_BY_ID);
        return this.executeBatch(entityList, batchSize, (sqlSession, entity) -> {
            MapperMethod.ParamMap param = new MapperMethod.ParamMap();
            param.put((Object)"et", entity);
            sqlSession.update(sqlStatement, (Object)param);
            if (entity instanceof SuperEntity) {
                String key = this.key(((SuperEntity)entity).getId());
                this.cacheChannel.evict(this.getRegion(), new String[]{key});
            }
        });
    }
}

