/*
 * Decompiled with CFR 0.152.
 */
package com.github.zuihou.boot.config;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.json.JsonReadFeature;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.github.zuihou.boot.undertow.UndertowServerFactoryCustomizer;
import com.github.zuihou.converter.String2DateConverter;
import com.github.zuihou.converter.String2LocalDateConverter;
import com.github.zuihou.converter.String2LocalDateTimeConverter;
import com.github.zuihou.converter.String2LocalTimeConverter;
import com.github.zuihou.jackson.MyJacksonModule;
import com.github.zuihou.utils.CodeGenerate;
import com.github.zuihou.utils.SpringUtils;
import io.undertow.Undertow;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.ZoneId;
import java.util.Date;
import java.util.Locale;
import java.util.TimeZone;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.AutoConfigureBefore;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.autoconfigure.jackson.JacksonAutoConfiguration;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Primary;
import org.springframework.core.convert.converter.Converter;
import org.springframework.http.converter.json.Jackson2ObjectMapperBuilder;

@AutoConfigureBefore(value={JacksonAutoConfiguration.class})
public abstract class BaseConfig {
    @Bean
    @Primary
    @ConditionalOnClass(value={ObjectMapper.class})
    @ConditionalOnMissingBean
    public ObjectMapper jacksonObjectMapper(Jackson2ObjectMapperBuilder builder) {
        ObjectMapper objectMapper = builder.createXmlMapper(false).build();
        objectMapper.setLocale(Locale.CHINA).configure(SerializationFeature.WRITE_DATES_AS_TIMESTAMPS, false).setTimeZone(TimeZone.getTimeZone(ZoneId.systemDefault())).setDateFormat((DateFormat)new SimpleDateFormat("yyyy-MM-dd HH:mm:ss", Locale.CHINA)).configure(JsonReadFeature.ALLOW_UNESCAPED_CONTROL_CHARS.mappedFeature(), true).configure(JsonReadFeature.ALLOW_BACKSLASH_ESCAPING_ANY_CHARACTER.mappedFeature(), true).findAndRegisterModules().configure(SerializationFeature.FAIL_ON_EMPTY_BEANS, false).configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false).configure(JsonParser.Feature.ALLOW_SINGLE_QUOTES, true);
        objectMapper.getDeserializationConfig().withoutFeatures(new DeserializationFeature[]{DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES});
        objectMapper.registerModule((Module)new MyJacksonModule());
        objectMapper.findAndRegisterModules();
        return objectMapper;
    }

    @Bean
    public Converter<String, Date> dateConvert() {
        return new String2DateConverter();
    }

    @Bean
    public Converter<String, LocalDate> localDateConverter() {
        return new String2LocalDateConverter();
    }

    @Bean
    public Converter<String, LocalTime> localTimeConverter() {
        return new String2LocalTimeConverter();
    }

    @Bean
    public Converter<String, LocalDateTime> localDateTimeConverter() {
        return new String2LocalDateTimeConverter();
    }

    @Bean(value={"codeGenerate"})
    public CodeGenerate codeGenerate(@Value(value="${id-generator.machine-code:1}") Long machineCode) {
        return new CodeGenerate(machineCode.intValue());
    }

    @Bean
    public SpringUtils getSpringUtils(ApplicationContext applicationContext) {
        SpringUtils.setApplicationContext((ApplicationContext)applicationContext);
        return new SpringUtils();
    }

    @ConditionalOnProperty(prefix="zuihou.webmvc", name={"enabled"}, havingValue="true", matchIfMissing=true)
    public static class WebMvcConfig {
        @Bean
        @ConditionalOnProperty(prefix="zuihou.webmvc", name={"enabled"}, havingValue="true", matchIfMissing=true)
        @ConditionalOnClass(value={Undertow.class})
        public UndertowServerFactoryCustomizer getUndertowServerFactoryCustomizer() {
            return new UndertowServerFactoryCustomizer();
        }
    }
}

