/*
 * Decompiled with CFR 0.152.
 */
package com.github.zuihou.boot.handler;

import cn.hutool.core.util.StrUtil;
import com.github.zuihou.base.R;
import com.github.zuihou.exception.BizException;
import com.github.zuihou.exception.code.ExceptionCode;
import java.sql.SQLException;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.validation.ConstraintViolation;
import javax.validation.ConstraintViolationException;
import org.apache.ibatis.exceptions.PersistenceException;
import org.hibernate.validator.internal.engine.path.PathImpl;
import org.mybatis.spring.MyBatisSystemException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.dao.DataIntegrityViolationException;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.converter.HttpMessageNotReadableException;
import org.springframework.validation.BindException;
import org.springframework.web.HttpMediaTypeNotSupportedException;
import org.springframework.web.HttpRequestMethodNotSupportedException;
import org.springframework.web.bind.MethodArgumentNotValidException;
import org.springframework.web.bind.MissingServletRequestParameterException;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.method.annotation.MethodArgumentTypeMismatchException;
import org.springframework.web.multipart.MultipartException;
import org.springframework.web.multipart.support.MissingServletRequestPartException;

public abstract class DefaultGlobalExceptionHandler {
    private static final Logger log = LoggerFactory.getLogger(DefaultGlobalExceptionHandler.class);

    @ExceptionHandler(value={BizException.class})
    @ResponseStatus(value=HttpStatus.BAD_REQUEST)
    public R bizException(BizException ex, HttpServletRequest request) {
        log.warn("BizException:", (Throwable)ex);
        return R.result((int)ex.getCode(), null, (String)ex.getMessage()).setPath(request.getRequestURI());
    }

    @ExceptionHandler(value={HttpMessageNotReadableException.class})
    @ResponseStatus(value=HttpStatus.BAD_REQUEST)
    public R httpMessageNotReadableException(HttpMessageNotReadableException ex, HttpServletRequest request) {
        log.warn("HttpMessageNotReadableException:", (Throwable)ex);
        String message = ex.getMessage();
        if (StrUtil.containsAny((CharSequence)message, (CharSequence[])new CharSequence[]{"Could not read document:"})) {
            String msg = String.format("\u65e0\u6cd5\u6b63\u786e\u7684\u89e3\u6790json\u7c7b\u578b\u7684\u53c2\u6570\uff1a%s", StrUtil.subBetween((CharSequence)message, (CharSequence)"Could not read document:", (CharSequence)" at "));
            return R.result((int)ExceptionCode.PARAM_EX.getCode(), null, (String)msg).setPath(request.getRequestURI());
        }
        return R.result((int)ExceptionCode.PARAM_EX.getCode(), null, (String)ExceptionCode.PARAM_EX.getMsg()).setPath(request.getRequestURI());
    }

    @ExceptionHandler(value={BindException.class})
    @ResponseStatus(value=HttpStatus.BAD_REQUEST)
    public R bindException(BindException ex, HttpServletRequest request) {
        log.warn("BindException:", (Throwable)ex);
        try {
            String msgs = ex.getBindingResult().getFieldError().getDefaultMessage();
            if (StrUtil.isNotEmpty((CharSequence)msgs)) {
                return R.result((int)ExceptionCode.PARAM_EX.getCode(), null, (String)msgs).setPath(request.getRequestURI());
            }
        }
        catch (Exception msgs) {
            // empty catch block
        }
        StringBuilder msg = new StringBuilder();
        List fieldErrors = ex.getFieldErrors();
        fieldErrors.forEach(oe -> msg.append("\u53c2\u6570:[").append(oe.getObjectName()).append(".").append(oe.getField()).append("]\u7684\u4f20\u5165\u503c:[").append(oe.getRejectedValue()).append("]\u4e0e\u9884\u671f\u7684\u5b57\u6bb5\u7c7b\u578b\u4e0d\u5339\u914d."));
        return R.result((int)ExceptionCode.PARAM_EX.getCode(), null, (String)msg.toString()).setPath(request.getRequestURI());
    }

    @ExceptionHandler(value={MethodArgumentTypeMismatchException.class})
    @ResponseStatus(value=HttpStatus.BAD_REQUEST)
    public R methodArgumentTypeMismatchException(MethodArgumentTypeMismatchException ex, HttpServletRequest request) {
        log.warn("MethodArgumentTypeMismatchException:", (Throwable)ex);
        MethodArgumentTypeMismatchException eee = ex;
        StringBuilder msg = new StringBuilder("\u53c2\u6570\uff1a[").append(eee.getName()).append("]\u7684\u4f20\u5165\u503c\uff1a[").append(eee.getValue()).append("]\u4e0e\u9884\u671f\u7684\u5b57\u6bb5\u7c7b\u578b\uff1a[").append(eee.getRequiredType().getName()).append("]\u4e0d\u5339\u914d");
        return R.result((int)ExceptionCode.PARAM_EX.getCode(), null, (String)msg.toString()).setPath(request.getRequestURI());
    }

    @ExceptionHandler(value={IllegalStateException.class})
    @ResponseStatus(value=HttpStatus.BAD_REQUEST)
    public R illegalStateException(IllegalStateException ex, HttpServletRequest request) {
        log.warn("IllegalStateException:", (Throwable)ex);
        return R.result((int)ExceptionCode.ILLEGALA_ARGUMENT_EX.getCode(), null, (String)ExceptionCode.ILLEGALA_ARGUMENT_EX.getMsg()).setPath(request.getRequestURI());
    }

    @ExceptionHandler(value={MissingServletRequestParameterException.class})
    @ResponseStatus(value=HttpStatus.BAD_REQUEST)
    public R missingServletRequestParameterException(MissingServletRequestParameterException ex, HttpServletRequest request) {
        log.warn("MissingServletRequestParameterException:", (Throwable)ex);
        StringBuilder msg = new StringBuilder();
        msg.append("\u7f3a\u5c11\u5fc5\u987b\u7684[").append(ex.getParameterType()).append("]\u7c7b\u578b\u7684\u53c2\u6570[").append(ex.getParameterName()).append("]");
        return R.result((int)ExceptionCode.ILLEGALA_ARGUMENT_EX.getCode(), null, (String)msg.toString()).setPath(request.getRequestURI());
    }

    @ExceptionHandler(value={NullPointerException.class})
    @ResponseStatus(value=HttpStatus.BAD_REQUEST)
    public R nullPointerException(NullPointerException ex, HttpServletRequest request) {
        log.warn("NullPointerException:", (Throwable)ex);
        return R.result((int)ExceptionCode.NULL_POINT_EX.getCode(), null, (String)ExceptionCode.NULL_POINT_EX.getMsg()).setPath(request.getRequestURI());
    }

    @ExceptionHandler(value={IllegalArgumentException.class})
    @ResponseStatus(value=HttpStatus.BAD_REQUEST)
    public R illegalArgumentException(IllegalArgumentException ex, HttpServletRequest request) {
        log.warn("IllegalArgumentException:", (Throwable)ex);
        return R.result((int)ExceptionCode.ILLEGALA_ARGUMENT_EX.getCode(), null, (String)ExceptionCode.ILLEGALA_ARGUMENT_EX.getMsg()).setPath(request.getRequestURI());
    }

    @ExceptionHandler(value={HttpMediaTypeNotSupportedException.class})
    @ResponseStatus(value=HttpStatus.BAD_REQUEST)
    public R httpMediaTypeNotSupportedException(HttpMediaTypeNotSupportedException ex, HttpServletRequest request) {
        log.warn("HttpMediaTypeNotSupportedException:", (Throwable)ex);
        MediaType contentType = ex.getContentType();
        if (contentType != null) {
            StringBuilder msg = new StringBuilder();
            msg.append("\u8bf7\u6c42\u7c7b\u578b(Content-Type)[").append(contentType.toString()).append("] \u4e0e\u5b9e\u9645\u63a5\u53e3\u7684\u8bf7\u6c42\u7c7b\u578b\u4e0d\u5339\u914d");
            return R.result((int)ExceptionCode.MEDIA_TYPE_EX.getCode(), null, (String)msg.toString()).setPath(request.getRequestURI());
        }
        return R.result((int)ExceptionCode.MEDIA_TYPE_EX.getCode(), null, (String)"\u65e0\u6548\u7684Content-Type\u7c7b\u578b").setPath(request.getRequestURI());
    }

    @ExceptionHandler(value={MissingServletRequestPartException.class})
    @ResponseStatus(value=HttpStatus.BAD_REQUEST)
    public R missingServletRequestPartException(MissingServletRequestPartException ex, HttpServletRequest request) {
        log.warn("MissingServletRequestPartException:", (Throwable)ex);
        return R.result((int)ExceptionCode.REQUIRED_FILE_PARAM_EX.getCode(), null, (String)ExceptionCode.REQUIRED_FILE_PARAM_EX.getMsg()).setPath(request.getRequestURI());
    }

    @ExceptionHandler(value={ServletException.class})
    @ResponseStatus(value=HttpStatus.BAD_REQUEST)
    public R servletException(ServletException ex, HttpServletRequest request) {
        log.warn("ServletException:", (Throwable)ex);
        String msg = "UT010016: Not a multi part request";
        if (msg.equalsIgnoreCase(ex.getMessage())) {
            return R.result((int)ExceptionCode.REQUIRED_FILE_PARAM_EX.getCode(), null, (String)ExceptionCode.REQUIRED_FILE_PARAM_EX.getMsg());
        }
        return R.result((int)ExceptionCode.SYSTEM_BUSY.getCode(), null, (String)ex.getMessage()).setPath(request.getRequestURI());
    }

    @ExceptionHandler(value={MultipartException.class})
    @ResponseStatus(value=HttpStatus.BAD_REQUEST)
    public R multipartException(MultipartException ex, HttpServletRequest request) {
        log.warn("MultipartException:", (Throwable)ex);
        return R.result((int)ExceptionCode.REQUIRED_FILE_PARAM_EX.getCode(), null, (String)ExceptionCode.REQUIRED_FILE_PARAM_EX.getMsg()).setPath(request.getRequestURI());
    }

    @ExceptionHandler(value={ConstraintViolationException.class})
    @ResponseStatus(value=HttpStatus.BAD_REQUEST)
    public R constraintViolationException(ConstraintViolationException ex, HttpServletRequest request) {
        log.warn("ConstraintViolationException:", (Throwable)ex);
        Set violations = ex.getConstraintViolations();
        String message = violations.stream().map(ConstraintViolation::getMessage).collect(Collectors.joining(";"));
        ConstraintViolation violation = (ConstraintViolation)violations.iterator().next();
        String path = ((PathImpl)violation.getPropertyPath()).getLeafNode().getName();
        String message2 = String.format("%s:%s", path, violation.getMessage());
        return R.result((int)ExceptionCode.BASE_VALID_PARAM.getCode(), null, (String)message).setPath(request.getRequestURI());
    }

    @ExceptionHandler(value={MethodArgumentNotValidException.class})
    @ResponseStatus(value=HttpStatus.BAD_REQUEST)
    public R methodArgumentNotValidException(MethodArgumentNotValidException ex, HttpServletRequest request) {
        log.warn("MethodArgumentNotValidException:", (Throwable)ex);
        return R.result((int)ExceptionCode.BASE_VALID_PARAM.getCode(), null, (String)ex.getBindingResult().getFieldError().getDefaultMessage()).setPath(request.getRequestURI());
    }

    @ExceptionHandler(value={Exception.class})
    @ResponseStatus(value=HttpStatus.BAD_REQUEST)
    public R otherExceptionHandler(Exception ex, HttpServletRequest request) {
        log.warn("Exception:", (Throwable)ex);
        if (ex.getCause() instanceof BizException) {
            return this.bizException((BizException)ex.getCause(), request);
        }
        return R.result((int)ExceptionCode.SYSTEM_BUSY.getCode(), null, (String)ExceptionCode.SYSTEM_BUSY.getMsg()).setPath(request.getRequestURI());
    }

    @ExceptionHandler(value={HttpRequestMethodNotSupportedException.class})
    @ResponseStatus(value=HttpStatus.BAD_REQUEST)
    public R handleHttpRequestMethodNotSupportedException(HttpRequestMethodNotSupportedException ex, HttpServletRequest request) {
        log.warn("HttpRequestMethodNotSupportedException:", (Throwable)ex);
        return R.result((int)ExceptionCode.METHOD_NOT_ALLOWED.getCode(), null, (String)ExceptionCode.METHOD_NOT_ALLOWED.getMsg()).setPath(request.getRequestURI());
    }

    @ExceptionHandler(value={PersistenceException.class})
    @ResponseStatus(value=HttpStatus.BAD_REQUEST)
    public R persistenceException(PersistenceException ex, HttpServletRequest request) {
        log.warn("PersistenceException:", (Throwable)ex);
        if (ex.getCause() instanceof BizException) {
            BizException cause = (BizException)ex.getCause();
            return R.result((int)cause.getCode(), null, (String)cause.getMessage());
        }
        return R.result((int)ExceptionCode.SQL_EX.getCode(), null, (String)ExceptionCode.SQL_EX.getMsg()).setPath(request.getRequestURI());
    }

    @ExceptionHandler(value={MyBatisSystemException.class})
    @ResponseStatus(value=HttpStatus.BAD_REQUEST)
    public R myBatisSystemException(MyBatisSystemException ex, HttpServletRequest request) {
        log.warn("PersistenceException:", (Throwable)ex);
        if (ex.getCause() instanceof PersistenceException) {
            return this.persistenceException((PersistenceException)ex.getCause(), request);
        }
        return R.result((int)ExceptionCode.SQL_EX.getCode(), null, (String)ExceptionCode.SQL_EX.getMsg()).setPath(request.getRequestURI());
    }

    @ExceptionHandler(value={SQLException.class})
    @ResponseStatus(value=HttpStatus.BAD_REQUEST)
    public R sqlException(SQLException ex, HttpServletRequest request) {
        log.warn("SQLException:", (Throwable)ex);
        return R.result((int)ExceptionCode.SQL_EX.getCode(), null, (String)ExceptionCode.SQL_EX.getMsg()).setPath(request.getRequestURI());
    }

    @ExceptionHandler(value={DataIntegrityViolationException.class})
    @ResponseStatus(value=HttpStatus.BAD_REQUEST)
    public R dataIntegrityViolationException(DataIntegrityViolationException ex, HttpServletRequest request) {
        log.warn("DataIntegrityViolationException:", (Throwable)ex);
        return R.result((int)ExceptionCode.SQL_EX.getCode(), null, (String)ExceptionCode.SQL_EX.getMsg()).setPath(request.getRequestURI());
    }
}

