/*
 * Decompiled with CFR 0.152.
 */
package com.github.zuihou.boot.undertow;

import io.undertow.connector.ByteBufferPool;
import io.undertow.server.DefaultByteBufferPool;
import io.undertow.websockets.jsr.WebSocketDeploymentInfo;
import java.io.IOException;
import org.springframework.boot.web.embedded.undertow.UndertowDeploymentInfoCustomizer;
import org.springframework.boot.web.embedded.undertow.UndertowServletWebServerFactory;
import org.springframework.boot.web.server.WebServerFactoryCustomizer;
import org.xnio.Option;
import org.xnio.OptionMap;
import org.xnio.Options;
import org.xnio.Xnio;
import org.xnio.XnioWorker;

public class UndertowServerFactoryCustomizer
implements WebServerFactoryCustomizer<UndertowServletWebServerFactory> {
    public void customize(UndertowServletWebServerFactory factory) {
        UndertowDeploymentInfoCustomizer undertowDeploymentInfoCustomizer = deploymentInfo -> {
            WebSocketDeploymentInfo info = (WebSocketDeploymentInfo)deploymentInfo.getServletContextAttributes().get("io.undertow.websockets.jsr.WebSocketDeploymentInfo");
            XnioWorker worker = this.getXnioWorker();
            DefaultByteBufferPool buffers = new DefaultByteBufferPool(Boolean.getBoolean("io.undertow.websockets.direct-buffers"), 1024, 100, 12);
            info.setWorker(worker);
            info.setBuffers((ByteBufferPool)buffers);
        };
        factory.addDeploymentInfoCustomizers(new UndertowDeploymentInfoCustomizer[]{undertowDeploymentInfoCustomizer});
    }

    private XnioWorker getXnioWorker() {
        XnioWorker worker = null;
        try {
            worker = Xnio.getInstance().createWorker(OptionMap.create((Option)Options.THREAD_DAEMON, (Object)true));
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return worker;
    }
}

