/*
 * Decompiled with CFR 0.152.
 */
package com.github.zuihou.cloud;

import com.github.zuihou.cloud.feign.DateFormatRegister;
import com.github.zuihou.cloud.hystrix.ThreadLocalHystrixConcurrencyStrategy;
import com.github.zuihou.cloud.interceptor.FeignAddHeaderRequestInterceptor;
import com.netflix.hystrix.HystrixCommand;
import feign.Feign;
import feign.RequestInterceptor;
import feign.codec.Encoder;
import feign.form.spring.SpringFormEncoder;
import feign.hystrix.HystrixFeign;
import java.util.Collection;
import java.util.List;
import org.springframework.beans.factory.ObjectFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.autoconfigure.http.HttpMessageConverters;
import org.springframework.cloud.openfeign.support.SpringEncoder;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Scope;
import org.springframework.web.client.RestTemplate;

public class OpenFeignAutoConfiguration {
    @Bean
    public DateFormatRegister dateFormatRegister() {
        return new DateFormatRegister();
    }

    @Bean
    public Encoder feignFormEncoder() {
        List converters = new RestTemplate().getMessageConverters();
        ObjectFactory factory = () -> new HttpMessageConverters((Collection)converters);
        return new SpringFormEncoder((Encoder)new SpringEncoder(factory));
    }

    @Bean
    public ThreadLocalHystrixConcurrencyStrategy getThreadLocalHystrixConcurrencyStrategy() {
        return new ThreadLocalHystrixConcurrencyStrategy();
    }

    @Configuration(value="hystrixFeignConfiguration")
    @ConditionalOnClass(value={HystrixCommand.class, HystrixFeign.class})
    protected static class HystrixFeignConfiguration {
        protected HystrixFeignConfiguration() {
        }

        @Bean
        @Scope(value="prototype")
        @ConditionalOnProperty(value={"feign.hystrix.enabled"})
        public Feign.Builder feignHystrixBuilder(RequestInterceptor requestInterceptor) {
            return HystrixFeign.builder().decode404().requestInterceptor(requestInterceptor);
        }

        @ConditionalOnMissingBean
        @Bean
        public FeignAddHeaderRequestInterceptor getClientTokenInterceptor() {
            return new FeignAddHeaderRequestInterceptor();
        }
    }
}

