/*
 * Decompiled with CFR 0.152.
 */
package com.github.zuihou.cloud.interceptor;

import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.StrUtil;
import com.github.zuihou.context.BaseContextHandler;
import feign.RequestInterceptor;
import feign.RequestTemplate;
import io.seata.core.context.RootContext;
import java.util.Arrays;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.context.request.RequestAttributes;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

public class FeignAddHeaderRequestInterceptor
implements RequestInterceptor {
    private static final Logger log = LoggerFactory.getLogger(FeignAddHeaderRequestInterceptor.class);
    public static final List<String> HEADER_NAME_LIST = Arrays.asList("tenant", "userid", "account", "name", "grayversion", "x-trace-header", "X-Real-IP", "x-forwarded-for");

    public void apply(RequestTemplate template) {
        RequestAttributes requestAttributes;
        String xid = RootContext.getXID();
        if (StrUtil.isNotEmpty((CharSequence)xid)) {
            template.header("TX_XID", new String[]{xid});
        }
        if ((requestAttributes = RequestContextHolder.getRequestAttributes()) == null) {
            HEADER_NAME_LIST.forEach(headerName -> template.header(headerName, new String[]{BaseContextHandler.get((String)headerName)}));
            return;
        }
        HttpServletRequest request = ((ServletRequestAttributes)requestAttributes).getRequest();
        if (request == null) {
            log.warn("path={}, \u5728FeignClient API\u63a5\u53e3\u672a\u914d\u7f6eFeignConfiguration\u7c7b\uff0c \u6545\u800c\u65e0\u6cd5\u5728\u8fdc\u7a0b\u8c03\u7528\u65f6\u83b7\u53d6\u8bf7\u6c42\u5934\u4e2d\u7684\u53c2\u6570!", (Object)template.path());
            return;
        }
        HEADER_NAME_LIST.forEach(headerName -> {
            String header = request.getHeader(headerName);
            template.header(headerName, new String[]{ObjectUtil.isEmpty((Object)header) ? BaseContextHandler.get((String)headerName) : header});
        });
    }
}

