/*
 * Decompiled with CFR 0.152.
 */
package com.github.zuihou.cloud.ribbon;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.util.StrUtil;
import com.alibaba.cloud.nacos.ribbon.NacosServer;
import com.github.zuihou.context.BaseContextHandler;
import com.google.common.base.Optional;
import com.netflix.loadbalancer.AvailabilityFilteringRule;
import com.netflix.loadbalancer.Server;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GrayRule
extends AvailabilityFilteringRule {
    private static final Logger log = LoggerFactory.getLogger(GrayRule.class);

    public Server choose(Object key) {
        List serverList = this.getPredicate().getEligibleServers(this.getLoadBalancer().getAllServers(), key);
        if (CollUtil.isEmpty((Collection)serverList)) {
            return null;
        }
        String serviceVersion = BaseContextHandler.getGrayVersion();
        log.debug("======>GrayMetadataRule:  serviceVersionTL{}", (Object)serviceVersion);
        ArrayList<Server> noMetaServerList = new ArrayList<Server>();
        ArrayList<Server> metaServerList = new ArrayList<Server>();
        for (Server server2 : serverList) {
            Map metadata = ((NacosServer)server2).getInstance().getMetadata();
            String metaVersion = (String)metadata.get("grayversion");
            if (StrUtil.isNotEmpty((CharSequence)metaVersion)) {
                metaServerList.add(server2);
                continue;
            }
            noMetaServerList.add(server2);
        }
        if (StrUtil.isEmpty((CharSequence)serviceVersion)) {
            if (noMetaServerList.isEmpty()) {
                return this.originChoose(metaServerList, key, serviceVersion);
            }
            log.debug("====> \u8bf7\u6c42\u672a\u6307\u5b9a\u670d\u52a1\u7248\u672c\uff0c\u5c06\u65e0\u7248\u672c\u53f7\u7684\u670d\u52a1\u8fdb\u884c\u8d1f\u8f7d\u5747\u8861");
            return this.originChoose(noMetaServerList, key, serviceVersion);
        }
        Map<String, List<Server>> listMap = metaServerList.stream().collect(Collectors.groupingBy(server -> (String)((NacosServer)server).getInstance().getMetadata().get("grayversion")));
        List<Server> servers = listMap.get(serviceVersion);
        if (CollUtil.isEmpty(servers)) {
            return this.originChoose((List)CollUtil.addAll(metaServerList, noMetaServerList), key, serviceVersion);
        }
        return this.originChoose(servers, key, serviceVersion);
    }

    private Server originChoose(List<Server> serverList, Object key, String serviceVersion) {
        if (CollUtil.isEmpty(serverList)) {
            log.error("====> \u7248\u672c\u53f7:{}\u5bf9\u5e94\u7684\u670d\u52a1\u5217\u8868\u4e3a\u7a7a\uff0c\u65e0\u6cd5\u8fdb\u884c\u8d1f\u8f7d\u5747\u8861", (Object)serviceVersion);
            return null;
        }
        Optional server = this.getPredicate().chooseRoundRobinAfterFiltering(serverList, key);
        if (server.isPresent()) {
            return (Server)server.get();
        }
        return null;
    }
}

