/*
 * Decompiled with CFR 0.152.
 */
package com.github.zuihou.base;

import com.alibaba.fastjson.JSONObject;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.github.zuihou.exception.BizException;
import com.github.zuihou.exception.code.BaseExceptionCode;
import io.swagger.annotations.ApiModelProperty;
import java.util.HashMap;
import java.util.Map;

public class R<T> {
    public static final String DEF_ERROR_MESSAGE = "\u7cfb\u7edf\u7e41\u5fd9\uff0c\u8bf7\u7a0d\u5019\u518d\u8bd5";
    public static final String HYSTRIX_ERROR_MESSAGE = "\u8bf7\u6c42\u8d85\u65f6\uff0c\u8bf7\u7a0d\u5019\u518d\u8bd5";
    public static final int SUCCESS_CODE = 0;
    public static final int FAIL_CODE = -1;
    public static final int TIMEOUT_CODE = -2;
    public static final int VALID_EX_CODE = -9;
    public static final int OPERATION_EX_CODE = -10;
    @ApiModelProperty(value="\u54cd\u5e94\u7f16\u7801:0/200-\u8bf7\u6c42\u5904\u7406\u6210\u529f")
    private int code;
    @JsonIgnore
    private Boolean defExec = true;
    @ApiModelProperty(value="\u54cd\u5e94\u6570\u636e")
    private T data;
    @ApiModelProperty(value="\u63d0\u793a\u6d88\u606f")
    private String msg = "ok";
    @ApiModelProperty(value="\u8bf7\u6c42\u8def\u5f84")
    private String path;
    @ApiModelProperty(value="\u9644\u52a0\u6570\u636e")
    private Map<Object, Object> extra;
    @ApiModelProperty(value="\u54cd\u5e94\u65f6\u95f4\u6233")
    private long timestamp = System.currentTimeMillis();

    private R() {
        this.defExec = false;
        this.timestamp = System.currentTimeMillis();
    }

    public R(int code, T data, String msg) {
        this.code = code;
        this.data = data;
        this.msg = msg;
        this.defExec = false;
        this.timestamp = System.currentTimeMillis();
    }

    public R(int code, T data, String msg, boolean defExec) {
        this.code = code;
        this.data = data;
        this.msg = msg;
        this.defExec = defExec;
        this.timestamp = System.currentTimeMillis();
    }

    public static <E> R<E> result(int code, E data, String msg) {
        return new R<E>(code, data, msg);
    }

    public static <E> R<E> success(E data) {
        return new R<E>(0, data, "ok");
    }

    public static R<Boolean> success() {
        return new R<Boolean>(0, true, "ok");
    }

    public static <E> R<E> successDef(E data) {
        return new R<E>(0, data, "ok", true);
    }

    public static <E> R<E> successDef() {
        return new R<Object>(0, null, "ok", true);
    }

    public static <E> R<E> successDef(E data, String msg) {
        return new R<E>(0, data, msg, true);
    }

    public static <E> R<E> success(E data, String msg) {
        return new R<E>(0, data, msg);
    }

    public static <E> R<E> fail(int code, String msg) {
        return new R<Object>(code, null, msg == null || msg.isEmpty() ? DEF_ERROR_MESSAGE : msg);
    }

    public static <E> R<E> fail(String msg) {
        return R.fail(-10, msg);
    }

    public static <E> R<E> fail(String msg, Object ... args) {
        String message = msg == null || msg.isEmpty() ? DEF_ERROR_MESSAGE : msg;
        return new R<Object>(-10, null, String.format(message, args));
    }

    public static <E> R<E> fail(BaseExceptionCode exceptionCode) {
        return R.validFail(exceptionCode);
    }

    public static <E> R<E> fail(BizException exception) {
        if (exception == null) {
            return R.fail(DEF_ERROR_MESSAGE);
        }
        return new R<Object>(exception.getCode(), null, exception.getMessage());
    }

    public static <E> R<E> fail(Throwable throwable) {
        return R.fail(-1, throwable != null ? throwable.getMessage() : DEF_ERROR_MESSAGE);
    }

    public static <E> R<E> validFail(String msg) {
        return new R<Object>(-9, null, msg == null || msg.isEmpty() ? DEF_ERROR_MESSAGE : msg);
    }

    public static <E> R<E> validFail(String msg, Object ... args) {
        String message = msg == null || msg.isEmpty() ? DEF_ERROR_MESSAGE : msg;
        return new R<Object>(-9, null, String.format(message, args));
    }

    public static <E> R<E> validFail(BaseExceptionCode exceptionCode) {
        return new R<Object>(exceptionCode.getCode(), null, exceptionCode.getMsg() == null || exceptionCode.getMsg().isEmpty() ? DEF_ERROR_MESSAGE : exceptionCode.getMsg());
    }

    public static <E> R<E> timeout() {
        return R.fail(-2, HYSTRIX_ERROR_MESSAGE);
    }

    public R<T> put(String key, Object value) {
        if (this.extra == null) {
            this.extra = new HashMap<Object, Object>(10);
        }
        this.extra.put(key, value);
        return this;
    }

    public R<T> putAll(Map<Object, Object> extra) {
        if (this.extra == null) {
            this.extra = new HashMap<Object, Object>(10);
        }
        this.extra.putAll(extra);
        return this;
    }

    public Boolean getIsSuccess() {
        return this.code == 0 || this.code == 200;
    }

    public Boolean getIsError() {
        return this.getIsSuccess() == false;
    }

    public String toString() {
        return JSONObject.toJSONString((Object)this);
    }

    public int getCode() {
        return this.code;
    }

    public Boolean getDefExec() {
        return this.defExec;
    }

    public T getData() {
        return this.data;
    }

    public String getMsg() {
        return this.msg;
    }

    public String getPath() {
        return this.path;
    }

    public Map<Object, Object> getExtra() {
        return this.extra;
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    public R<T> setCode(int code) {
        this.code = code;
        return this;
    }

    public R<T> setDefExec(Boolean defExec) {
        this.defExec = defExec;
        return this;
    }

    public R<T> setData(T data) {
        this.data = data;
        return this;
    }

    public R<T> setMsg(String msg) {
        this.msg = msg;
        return this;
    }

    public R<T> setPath(String path) {
        this.path = path;
        return this;
    }

    public R<T> setExtra(Map<Object, Object> extra) {
        this.extra = extra;
        return this;
    }

    public R<T> setTimestamp(long timestamp) {
        this.timestamp = timestamp;
        return this;
    }
}

