/*
 * Decompiled with CFR 0.152.
 */
package com.github.zuihou.context;

import cn.hutool.core.convert.Convert;
import java.util.HashMap;
import java.util.Map;

public class BaseContextHandler {
    private static final ThreadLocal<Map<String, String>> THREAD_LOCAL = new ThreadLocal();

    public static void set(String key, Object value) {
        Map<String, String> map = BaseContextHandler.getLocalMap();
        map.put(key, value == null ? "" : value.toString());
    }

    public static <T> T get(String key, Class<T> type) {
        Map<String, String> map = BaseContextHandler.getLocalMap();
        return (T)Convert.convert(type, (Object)map.get(key));
    }

    public static <T> T get(String key, Class<T> type, Object def) {
        Map<String, String> map = BaseContextHandler.getLocalMap();
        return (T)Convert.convert(type, (Object)map.getOrDefault(key, String.valueOf(def == null ? "" : def)));
    }

    public static String get(String key) {
        Map<String, String> map = BaseContextHandler.getLocalMap();
        return map.getOrDefault(key, "");
    }

    public static Map<String, String> getLocalMap() {
        Map<String, String> map = THREAD_LOCAL.get();
        if (map == null) {
            map = new HashMap<String, String>(10);
            THREAD_LOCAL.set(map);
        }
        return map;
    }

    public static void setLocalMap(Map<String, String> threadLocalMap) {
        THREAD_LOCAL.set(threadLocalMap);
    }

    public static Boolean getBoot() {
        return BaseContextHandler.get("boot", Boolean.class, false);
    }

    public static void setBoot(Boolean val) {
        BaseContextHandler.set("boot", val);
    }

    public static Long getUserId() {
        return BaseContextHandler.get("userid", Long.class, 0L);
    }

    public static String getUserIdStr() {
        return String.valueOf(BaseContextHandler.getUserId());
    }

    public static void setUserId(Long userId) {
        BaseContextHandler.set("userid", userId);
    }

    public static void setUserId(String userId) {
        BaseContextHandler.set("userid", userId);
    }

    public static String getAccount() {
        return BaseContextHandler.get("account", String.class);
    }

    public static void setAccount(String name) {
        BaseContextHandler.set("account", name);
    }

    public static String getName() {
        return BaseContextHandler.get("name", String.class);
    }

    public static void setName(String account) {
        BaseContextHandler.set("name", account);
    }

    public static String getToken() {
        return BaseContextHandler.get("token", String.class);
    }

    public static void setToken(String token) {
        BaseContextHandler.set("token", token);
    }

    public static String getTenant() {
        return BaseContextHandler.get("tenant", String.class);
    }

    public static String getClientId() {
        return BaseContextHandler.get("client_id", String.class);
    }

    public static void setTenant(String val) {
        BaseContextHandler.set("tenant", val);
    }

    public static void setClientId(String val) {
        BaseContextHandler.set("client_id", val);
    }

    public static String getGrayVersion() {
        return BaseContextHandler.get("grayversion", String.class);
    }

    public static void setGrayVersion(String val) {
        BaseContextHandler.set("grayversion", val);
    }

    public static void remove() {
        if (THREAD_LOCAL != null) {
            THREAD_LOCAL.remove();
        }
    }
}

