/*
 * Decompiled with CFR 0.152.
 */
package com.github.zuihou.converter;

import cn.hutool.core.util.StrUtil;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import java.io.IOException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;

public class EnumDeserializer
extends StdDeserializer<Enum<?>> {
    private static final Logger log = LoggerFactory.getLogger(EnumDeserializer.class);
    public static final EnumDeserializer INSTANCE = new EnumDeserializer();

    public EnumDeserializer() {
        super(Enum.class);
    }

    public Enum<?> deserialize(JsonParser jp, DeserializationContext ctxt) throws IOException, JsonProcessingException {
        try {
            String val;
            JsonNode node = (JsonNode)jp.getCodec().readTree(jp);
            String currentName = jp.currentName();
            Object currentValue = jp.getCurrentValue();
            Class findPropertyType = BeanUtils.findPropertyType((String)currentName, (Class[])new Class[]{currentValue.getClass()});
            JsonNode code = node.get("code");
            String string = val = code != null ? code.asText() : node.asText();
            if (StrUtil.isBlank((CharSequence)val) || "null".equals(val)) {
                return null;
            }
            return Enum.valueOf(findPropertyType, val);
        }
        catch (Exception e) {
            log.warn("\u89e3\u6790\u679a\u4e3e\u5931\u8d25", (Throwable)e);
            return null;
        }
    }
}

