/*
 * Decompiled with CFR 0.152.
 */
package com.github.zuihou.converter;

import com.github.zuihou.converter.BaseDateConverter;
import com.github.zuihou.exception.BizException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.convert.converter.Converter;

public class String2DateConverter
extends BaseDateConverter<Date>
implements Converter<String, Date> {
    private static final Logger log = LoggerFactory.getLogger(String2DateConverter.class);
    protected static final Map<String, String> FORMAT = new LinkedHashMap<String, String>(13);

    protected static Date parseDate(String dateStr, String format) {
        Date date = null;
        try {
            SimpleDateFormat dateFormat = new SimpleDateFormat(format);
            dateFormat.setLenient(false);
            date = dateFormat.parse(dateStr);
        }
        catch (ParseException e) {
            log.info("\u8f6c\u6362\u65e5\u671f\u5931\u8d25, date={}, format={}", new Object[]{dateStr, format, e});
            throw new BizException(-9, e.getMessage());
        }
        return date;
    }

    @Override
    protected Map<String, String> getFormat() {
        return FORMAT;
    }

    public Date convert(String source) {
        return super.convert(source, key -> String2DateConverter.parseDate(source, key));
    }

    static {
        FORMAT.put("yyyy", "^\\d{4}");
        FORMAT.put("yyyy-MM", "^\\d{4}-\\d{1,2}$");
        FORMAT.put("yyyy-MM-dd", "^\\d{4}-\\d{1,2}-\\d{1,2}$");
        FORMAT.put("yyyy-MM-dd HH", "^\\d{4}-\\d{1,2}-\\d{1,2} {1}\\d{1,2}");
        FORMAT.put("yyyy-MM-dd HH:mm", "^\\d{4}-\\d{1,2}-\\d{1,2} {1}\\d{1,2}:\\d{1,2}$");
        FORMAT.put("yyyy-MM-dd HH:mm:ss", "^\\d{4}-\\d{1,2}-\\d{1,2} {1}\\d{1,2}:\\d{1,2}:\\d{1,2}$");
        FORMAT.put("yyyy/MM", "^\\d{4}/\\d{1,2}$");
        FORMAT.put("yyyy/MM/dd", "^\\d{4}/\\d{1,2}/\\d{1,2}$");
        FORMAT.put("yyyy/MM/dd HH", "^\\d{4}/\\d{1,2}/\\d{1,2} {1}\\d{1,2}");
        FORMAT.put("yyyy/MM/dd HH:mm", "^\\d{4}/\\d{1,2}/\\d{1,2} {1}\\d{1,2}:\\d{1,2}$");
        FORMAT.put("yyyy/MM/dd HH:mm:ss", "^\\d{4}/\\d{1,2}/\\d{1,2} {1}\\d{1,2}:\\d{1,2}:\\d{1,2}$");
        FORMAT.put("yyyy\u5e74MM\u6708dd\u65e5", "^\\d{4}\u5e74\\d{1,2}\u6708\\d{1,2}\u65e5$");
        FORMAT.put("yyyy\u5e74MM\u6708dd\u65e5HH\u65f6mm\u5206ss\u79d2", "^\\d{4}\u5e74\\d{1,2}\u6708\\d{1,2}\u65e5\\d{1,2}\u65f6\\d{1,2}\u5206\\d{1,2}\u79d2$");
    }
}

