/*
 * Decompiled with CFR 0.152.
 */
package com.github.zuihou.converter;

import com.github.zuihou.converter.BaseDateConverter;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.util.LinkedHashMap;
import java.util.Map;
import org.springframework.core.convert.converter.Converter;

public class String2LocalDateConverter
extends BaseDateConverter<LocalDate>
implements Converter<String, LocalDate> {
    protected static final Map<String, String> FORMAT = new LinkedHashMap<String, String>(2);

    @Override
    protected Map<String, String> getFormat() {
        return FORMAT;
    }

    public LocalDate convert(String source) {
        return super.convert(source, key -> LocalDate.parse(source, DateTimeFormatter.ofPattern(key)));
    }

    static {
        FORMAT.put("yyyy-MM-dd", "^\\d{4}-\\d{1,2}-\\d{1,2}$");
        FORMAT.put("yyyy/MM/dd", "^\\d{4}/\\d{1,2}/\\d{1,2}$");
        FORMAT.put("yyyy\u5e74MM\u6708dd\u65e5", "^\\d{4}\u5e74\\d{1,2}\u6708\\d{1,2}\u65e5$");
    }
}

