/*
 * Decompiled with CFR 0.152.
 */
package com.github.zuihou.jackson;

import cn.hutool.core.util.StrUtil;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.json.JsonReadFeature;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.github.zuihou.exception.BizException;
import com.github.zuihou.exception.code.ExceptionCode;
import com.github.zuihou.jackson.MyJacksonModule;
import java.io.IOException;
import java.io.InputStream;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.time.ZoneId;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JsonUtil {
    private static final Logger log = LoggerFactory.getLogger(JsonUtil.class);

    public static <T> String toJson(T value) {
        try {
            return JsonUtil.getInstance().writeValueAsString(value);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return null;
        }
    }

    public static byte[] toJsonAsBytes(Object object) {
        try {
            return JsonUtil.getInstance().writeValueAsBytes(object);
        }
        catch (JsonProcessingException e) {
            throw new BizException(ExceptionCode.JSON_PARSE_ERROR.getCode(), (Throwable)e);
        }
    }

    public static <T> T parse(String content, Class<T> valueType) {
        try {
            return (T)JsonUtil.getInstance().readValue(content, valueType);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return null;
        }
    }

    public static <T> T parse(String content, TypeReference<T> typeReference) {
        try {
            return (T)JsonUtil.getInstance().readValue(content, typeReference);
        }
        catch (IOException e) {
            throw new BizException(ExceptionCode.JSON_PARSE_ERROR.getCode(), (Throwable)e);
        }
    }

    public static <T> T parse(byte[] bytes, Class<T> valueType) {
        try {
            return (T)JsonUtil.getInstance().readValue(bytes, valueType);
        }
        catch (IOException e) {
            throw new BizException(ExceptionCode.JSON_PARSE_ERROR.getCode(), (Throwable)e);
        }
    }

    public static <T> T parse(byte[] bytes, TypeReference<T> typeReference) {
        try {
            return (T)JsonUtil.getInstance().readValue(bytes, typeReference);
        }
        catch (IOException e) {
            throw new BizException(ExceptionCode.JSON_PARSE_ERROR.getCode(), (Throwable)e);
        }
    }

    public static <T> T parse(InputStream in, Class<T> valueType) {
        try {
            return (T)JsonUtil.getInstance().readValue(in, valueType);
        }
        catch (IOException e) {
            throw new BizException(ExceptionCode.JSON_PARSE_ERROR.getCode(), (Throwable)e);
        }
    }

    public static <T> T parse(InputStream in, TypeReference<T> typeReference) {
        try {
            return (T)JsonUtil.getInstance().readValue(in, typeReference);
        }
        catch (IOException e) {
            throw new BizException(ExceptionCode.JSON_PARSE_ERROR.getCode(), (Throwable)e);
        }
    }

    public static <T> List<T> parseArray(String content, Class<T> valueTypeRef) {
        try {
            if (!StrUtil.startWith((CharSequence)content, (CharSequence)"[")) {
                content = "[" + content + "]";
            }
            List list = (List)JsonUtil.getInstance().readValue(content, (TypeReference)new TypeReference<List<Map<String, Object>>>(){});
            return list.stream().map(map -> JsonUtil.toPojo(map, valueTypeRef)).collect(Collectors.toList());
        }
        catch (IOException e) {
            log.error(e.getMessage(), (Throwable)e);
            return null;
        }
    }

    public static Map<String, Object> toMap(String content) {
        try {
            return (Map)JsonUtil.getInstance().readValue(content, Map.class);
        }
        catch (IOException e) {
            log.error(e.getMessage(), (Throwable)e);
            return null;
        }
    }

    public static <T> Map<String, T> toMap(String content, Class<T> valueTypeRef) {
        try {
            Map map = (Map)JsonUtil.getInstance().readValue(content, (TypeReference)new TypeReference<Map<String, Map<String, Object>>>(){});
            HashMap result = new HashMap(map.size());
            map.forEach((key, value) -> result.put(key, JsonUtil.toPojo(value, valueTypeRef)));
            return result;
        }
        catch (IOException e) {
            log.error(e.getMessage(), (Throwable)e);
            return null;
        }
    }

    public static <T> T toPojo(Map fromValue, Class<T> toValueType) {
        return (T)JsonUtil.getInstance().convertValue((Object)fromValue, toValueType);
    }

    public static <T> T toPojo(JsonNode resultNode, Class<T> toValueType) {
        return (T)JsonUtil.getInstance().convertValue((Object)resultNode, toValueType);
    }

    public static JsonNode readTree(String jsonString) {
        try {
            return JsonUtil.getInstance().readTree(jsonString);
        }
        catch (IOException e) {
            throw new BizException(ExceptionCode.JSON_PARSE_ERROR.getCode(), (Throwable)e);
        }
    }

    public static JsonNode readTree(InputStream in) {
        try {
            return JsonUtil.getInstance().readTree(in);
        }
        catch (IOException e) {
            throw new BizException(ExceptionCode.JSON_PARSE_ERROR.getCode(), (Throwable)e);
        }
    }

    public static JsonNode readTree(byte[] content) {
        try {
            return JsonUtil.getInstance().readTree(content);
        }
        catch (IOException e) {
            throw new BizException(ExceptionCode.JSON_PARSE_ERROR.getCode(), (Throwable)e);
        }
    }

    public static JsonNode readTree(JsonParser jsonParser) {
        try {
            return (JsonNode)JsonUtil.getInstance().readTree(jsonParser);
        }
        catch (IOException e) {
            throw new BizException(ExceptionCode.JSON_PARSE_ERROR.getCode(), (Throwable)e);
        }
    }

    public static ObjectMapper getInstance() {
        return JacksonHolder.INSTANCE;
    }

    public static class JacksonObjectMapper
    extends ObjectMapper {
        private static final long serialVersionUID = 1L;

        public JacksonObjectMapper() {
            super.setLocale(Locale.CHINA).configure(SerializationFeature.WRITE_DATES_AS_TIMESTAMPS, false).setTimeZone(TimeZone.getTimeZone(ZoneId.systemDefault())).setDateFormat((DateFormat)new SimpleDateFormat("yyyy-MM-dd HH:mm:ss", Locale.CHINA)).configure(JsonReadFeature.ALLOW_UNESCAPED_CONTROL_CHARS.mappedFeature(), true).configure(JsonReadFeature.ALLOW_BACKSLASH_ESCAPING_ANY_CHARACTER.mappedFeature(), true).findAndRegisterModules().configure(SerializationFeature.FAIL_ON_EMPTY_BEANS, false).configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false).configure(JsonParser.Feature.ALLOW_SINGLE_QUOTES, true).getDeserializationConfig().withoutFeatures(new DeserializationFeature[]{DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES});
            super.registerModule((Module)new MyJacksonModule());
            super.findAndRegisterModules();
        }

        public ObjectMapper copy() {
            return super.copy();
        }
    }

    private static class JacksonHolder {
        private static final ObjectMapper INSTANCE = new JacksonObjectMapper();

        private JacksonHolder() {
        }
    }
}

