/*
 * Decompiled with CFR 0.152.
 */
package com.github.zuihou.utils;

import cn.hutool.core.util.ArrayUtil;
import java.util.HashMap;
import java.util.Map;

public class AntiSqlFilter {
    private static final String[] KEY_WORDS = new String[]{";", "\"", "'", "/*", "*/", "--", "exec", "select", "update", "delete", "insert", "alter", "drop", "create", "shutdown"};

    public static Map<String, String[]> getSafeParameterMap(Map<String, String[]> parameterMap) {
        HashMap<String, String[]> map = new HashMap<String, String[]>(parameterMap.size());
        for (String key : parameterMap.keySet()) {
            String[] oldValues = parameterMap.get(key);
            map.put(key, AntiSqlFilter.getSafeValues(oldValues));
        }
        return map;
    }

    public static String[] getSafeValues(String[] oldValues) {
        if (ArrayUtil.isNotEmpty((Object[])oldValues)) {
            String[] newValues = new String[oldValues.length];
            for (int i = 0; i < oldValues.length; ++i) {
                newValues[i] = AntiSqlFilter.getSafeValue(oldValues[i]);
            }
            return newValues;
        }
        return null;
    }

    public static String getSafeValue(String oldValue) {
        if (oldValue == null || "".equals(oldValue)) {
            return oldValue;
        }
        StringBuilder sb = new StringBuilder(oldValue);
        String lowerCase = oldValue.toLowerCase();
        for (String keyWord : KEY_WORDS) {
            int x;
            while ((x = lowerCase.indexOf(keyWord)) >= 0) {
                if (keyWord.length() == 1) {
                    sb.replace(x, x + 1, " ");
                    lowerCase = sb.toString().toLowerCase();
                    continue;
                }
                sb.delete(x, x + keyWord.length());
                lowerCase = sb.toString().toLowerCase();
            }
        }
        return sb.toString();
    }
}

