/*
 * Decompiled with CFR 0.152.
 */
package com.github.zuihou.utils;

import cn.hutool.core.util.ArrayUtil;
import com.github.zuihou.exception.BizException;
import com.github.zuihou.exception.code.BaseExceptionCode;
import java.time.LocalDateTime;
import java.util.Collection;

public class BizAssert {
    private BizAssert() {
    }

    public static void fail(int code, String message) {
        throw new BizException(code, message);
    }

    public static void fail(BaseExceptionCode exceptionCode) {
        if (exceptionCode != null) {
            throw new BizException(exceptionCode.getCode(), exceptionCode.getMsg());
        }
        BizAssert.fail(-9, "\u53c2\u6570\u9a8c\u8bc1\u5f02\u5e38");
    }

    public static void fail() {
        BizAssert.fail(-9, "\u53c2\u6570\u9a8c\u8bc1\u5f02\u5e38");
    }

    public static void fail(String message) {
        if (message == null || "".equals(message)) {
            message = "\u53c2\u6570\u9a8c\u8bc1\u5f02\u5e38";
        }
        BizAssert.fail(-9, message);
    }

    public static void isTrue(boolean condition, BaseExceptionCode exceptionCode) {
        if (!condition) {
            BizAssert.fail(exceptionCode);
        }
    }

    public static void isTrue(boolean condition, String exceptionMessage) {
        if (!condition) {
            BizAssert.fail(exceptionMessage);
        }
    }

    public static void isTrue(boolean condition) {
        if (!condition) {
            BizAssert.fail();
        }
    }

    public static void isFalse(boolean condition, BaseExceptionCode exceptionCode) {
        if (condition) {
            BizAssert.fail(exceptionCode);
        }
    }

    public static void isFalse(boolean condition, String exceptionMessage) {
        if (condition) {
            BizAssert.fail(exceptionMessage);
        }
    }

    public static void notNull(Object object, BaseExceptionCode exceptionCode) {
        if (object == null) {
            BizAssert.fail(exceptionCode);
        }
    }

    public static void notNull(Object object) {
        if (object == null) {
            BizAssert.fail();
        }
    }

    public static void notNull(Object object, String message) {
        if (object == null) {
            BizAssert.fail(message);
        }
    }

    public static void isNull(Object object, BaseExceptionCode exceptionCode) {
        if (object != null) {
            BizAssert.fail(exceptionCode);
        }
    }

    public static void notEmpty(Collection<?> collection, BaseExceptionCode exceptionCode) {
        if (collection == null || collection.isEmpty()) {
            BizAssert.fail(exceptionCode);
        }
    }

    public static <T> void notEmpty(T[] array, BaseExceptionCode exceptionCode) {
        if (ArrayUtil.hasNull((Object[])array)) {
            BizAssert.fail(exceptionCode);
        }
    }

    public static void notEmpty(String value, BaseExceptionCode exceptionCode) {
        if (value == null || value.isEmpty()) {
            BizAssert.fail(exceptionCode);
        }
    }

    public static void notEmpty(String value, String exceptionMsgs) {
        if (value == null || value.isEmpty()) {
            BizAssert.fail(exceptionMsgs);
        }
    }

    public static void notEmpty(String value) {
        if (value == null || value.isEmpty()) {
            BizAssert.fail();
        }
    }

    public static void notEquals(Object unexpected, Object actual, BaseExceptionCode exceptionCode) {
        if (unexpected == actual) {
            BizAssert.fail(exceptionCode);
        }
        if (unexpected != null && unexpected.equals(actual)) {
            BizAssert.fail(exceptionCode);
        }
    }

    public static void equals(String expected, String actual, BaseExceptionCode exceptionCode) {
        if (expected == null && actual == null) {
            return;
        }
        if (expected != null && expected.equals(actual)) {
            return;
        }
        BizAssert.fail(exceptionCode);
    }

    public static void equals(String expected, String actual, String exceptionMsgs) {
        if (expected == null && actual == null) {
            return;
        }
        if (expected != null && expected.equals(actual)) {
            return;
        }
        BizAssert.fail(exceptionMsgs);
    }

    public static void equals(Object expected, Object actual, String exceptionMsgs) {
        if (expected == null && actual == null) {
            return;
        }
        if (expected != null && expected.equals(actual)) {
            return;
        }
        BizAssert.fail(exceptionMsgs);
    }

    public static void gt(LocalDateTime expected, LocalDateTime actual, String exceptionMsgs) {
        if (expected == null || actual == null) {
            BizAssert.fail(exceptionMsgs);
        }
        if (expected.isAfter(actual)) {
            BizAssert.fail(exceptionMsgs);
        }
    }
}

