/*
 * Decompiled with CFR 0.152.
 */
package com.github.zuihou.utils;

import java.util.concurrent.atomic.AtomicLong;

public class CodeGenerate {
    public static final char[] CHARS = new char[]{'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z'};
    public static final int CHARS_NUM = CHARS.length;
    private static final int MAX_MACHINE_CODE = 15;
    private static final long START_TIME = 1548954061000L;
    private final int MACHINE_CODE;
    private AtomicLong orderNo;

    public CodeGenerate(int machineCode) {
        if (machineCode < 0 || machineCode > 15) {
            throw new IllegalArgumentException("\u8bf7\u6ce8\u610f\uff0c1\u3001\u673a\u5668\u7801\u5728\u591a\u53f0\u673a\u5668\u6216\u5e94\u7528\u95f4\u662f\u4e0d\u5141\u8bb8\u91cd\u590d\u7684\uff012\u3001\u673a\u5668\u7801\u53d6\u503c\u4ec5\u4ec5\u5728[0,15]\u95ed\u533a\u95f4");
        }
        this.MACHINE_CODE = machineCode;
        this.orderNo = new AtomicLong((System.currentTimeMillis() - 1548954061000L) / 100L);
    }

    public String next() {
        long orderNo = this.orderNo.incrementAndGet();
        return this.encoded(orderNo << 4 | (long)this.MACHINE_CODE);
    }

    private String encoded(long id) {
        char[] result = new char[8];
        result[0] = CHARS[CHARS.length - 1];
        int unit = CHARS_NUM;
        int index = result.length - 1;
        do {
            result[index] = CHARS[(int)(id % (long)unit)];
            --index;
        } while ((id /= (long)unit) != 0L);
        return new String(result);
    }
}

