/*
 * Decompiled with CFR 0.152.
 */
package com.github.zuihou.utils;

import cn.hutool.core.collection.CollUtil;
import com.google.common.base.Preconditions;
import com.google.common.collect.HashBiMap;
import com.google.common.collect.ImmutableMap;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import java.util.function.Function;

public class MapHelper {
    public static <K, V, M> ImmutableMap<K, M> uniqueIndex(Iterable<V> values, Function<? super V, K> keyFunction, Function<? super V, M> valueFunction) {
        Iterator<V> iterator = values.iterator();
        Preconditions.checkNotNull(keyFunction);
        Preconditions.checkNotNull(valueFunction);
        ImmutableMap.Builder builder = ImmutableMap.builder();
        while (iterator.hasNext()) {
            V value = iterator.next();
            builder.put(keyFunction.apply(value), valueFunction.apply(value));
        }
        try {
            return builder.build();
        }
        catch (IllegalArgumentException duplicateKeys) {
            throw new IllegalArgumentException(duplicateKeys.getMessage() + ".\u82e5\u8981\u5728\u952e\u4e0b\u7d22\u5f15\u591a\u4e2a\u503c\uff0c\u8bf7\u4f7f\u7528: Multimaps.index.");
        }
    }

    public static <K, V> Map<V, K> inverse(Map<K, V> map) {
        if (CollUtil.isEmpty(map)) {
            return Collections.emptyMap();
        }
        HashBiMap biMap = HashBiMap.create();
        map.forEach((arg_0, arg_1) -> ((HashBiMap)biMap).forcePut(arg_0, arg_1));
        return biMap.inverse();
    }
}

