/*
 * Decompiled with CFR 0.152.
 */
package com.github.zuihou.utils;

import java.util.Map;
import org.springframework.context.ApplicationContext;
import org.springframework.util.Assert;

public class SpringUtils {
    private static ApplicationContext applicationContext;
    private static ApplicationContext parentApplicationContext;

    public static ApplicationContext getApplicationContext() {
        return applicationContext;
    }

    public static void setApplicationContext(ApplicationContext ctx) {
        Assert.notNull((Object)ctx, (String)"SpringUtil injection ApplicationContext is null");
        applicationContext = ctx;
        parentApplicationContext = ctx.getParent();
    }

    public static Object getBean(String name) {
        Assert.hasText((String)name, (String)"SpringUtil name is null or empty");
        try {
            return applicationContext.getBean(name);
        }
        catch (Exception e) {
            return parentApplicationContext.getBean(name);
        }
    }

    public static <T> T getBean(String name, Class<T> type) {
        Assert.hasText((String)name, (String)"SpringUtil name is null or empty");
        Assert.notNull(type, (String)"SpringUtil type is null");
        try {
            return (T)applicationContext.getBean(name, type);
        }
        catch (Exception e) {
            return (T)parentApplicationContext.getBean(name, type);
        }
    }

    public static <T> T getBean(Class<T> type) {
        Assert.notNull(type, (String)"SpringUtil type is null");
        try {
            return (T)applicationContext.getBean(type);
        }
        catch (Exception e) {
            return (T)parentApplicationContext.getBean(type);
        }
    }

    public static <T> Map<String, T> getBeansOfType(Class<T> type) {
        Assert.notNull(type, (String)"SpringUtil type is null");
        try {
            return applicationContext.getBeansOfType(type);
        }
        catch (Exception e) {
            return parentApplicationContext.getBeansOfType(type);
        }
    }

    public static ApplicationContext publishEvent(Object event) {
        applicationContext.publishEvent(event);
        return applicationContext;
    }
}

