/*
 * Decompiled with CFR 0.152.
 */
package com.github.zuihou.utils;

import cn.hutool.core.collection.CollUtil;
import com.github.zuihou.base.entity.TreeEntity;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;

public class TreeUtil {
    public static <E extends TreeEntity<E, ? extends Serializable>> List<E> buildTree(List<E> treeList) {
        if (CollUtil.isEmpty(treeList)) {
            return treeList;
        }
        ArrayList<Serializable> selfIdEqSelfParent = new ArrayList<Serializable>();
        for (TreeEntity parent : treeList) {
            Serializable id = (Serializable)parent.getId();
            for (TreeEntity children : treeList) {
                if (parent != children) {
                    if (!id.equals(children.getParentId())) continue;
                    parent.initChildren();
                    parent.getChildren().add(children);
                    continue;
                }
                if (!id.equals(parent.getParentId())) continue;
                selfIdEqSelfParent.add(id);
            }
        }
        ArrayList<TreeEntity> trees = new ArrayList<TreeEntity>();
        List allIds = treeList.stream().map(node -> (Serializable)node.getId()).collect(Collectors.toList());
        for (TreeEntity baseNode : treeList) {
            if (allIds.contains(baseNode.getParentId()) && !selfIdEqSelfParent.contains(baseNode.getParentId())) continue;
            trees.add(baseNode);
        }
        return trees;
    }
}

