/*
 * Decompiled with CFR 0.152.
 */
package com.github.zuihou.dozer;

import com.github.dozermapper.core.Mapper;
import com.github.dozermapper.spring.DozerBeanMapperFactoryBean;
import com.github.zuihou.dozer.DozerProperties;
import com.github.zuihou.dozer.DozerUtils;
import java.io.IOException;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
@ConditionalOnClass(value={DozerBeanMapperFactoryBean.class, Mapper.class})
@ConditionalOnMissingBean(value={Mapper.class})
@EnableConfigurationProperties(value={DozerProperties.class})
public class DozerAutoConfiguration {
    private final DozerProperties properties;

    public DozerAutoConfiguration(DozerProperties properties) {
        this.properties = properties;
    }

    @Bean
    public DozerUtils getDozerUtils(Mapper mapper) {
        return new DozerUtils(mapper);
    }

    @Bean
    public DozerBeanMapperFactoryBean dozerMapper() throws IOException {
        DozerBeanMapperFactoryBean factoryBean = new DozerBeanMapperFactoryBean();
        factoryBean.setMappingFiles(this.properties.resolveMapperLocations());
        return factoryBean;
    }
}

