/*
 * Decompiled with CFR 0.152.
 */
package com.github.zuihou.jwt.utils;

import cn.hutool.core.util.StrUtil;
import com.github.zuihou.exception.BizException;
import com.github.zuihou.exception.code.BaseExceptionCode;
import com.github.zuihou.exception.code.ExceptionCode;
import com.github.zuihou.jwt.model.Token;
import com.github.zuihou.utils.Charsets;
import io.jsonwebtoken.Claims;
import io.jsonwebtoken.ExpiredJwtException;
import io.jsonwebtoken.JwtBuilder;
import io.jsonwebtoken.Jwts;
import io.jsonwebtoken.SignatureAlgorithm;
import io.jsonwebtoken.security.SignatureException;
import java.security.Key;
import java.util.Base64;
import java.util.Date;
import java.util.Map;
import javax.crypto.spec.SecretKeySpec;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JwtUtil {
    private static final Logger log = LoggerFactory.getLogger(JwtUtil.class);
    private static String BASE64_SECURITY = Base64.getEncoder().encodeToString("zuihou-admin-cloud_is_a_fantastic_project".getBytes(Charsets.UTF_8));

    public static String[] getClient(String basicHeader) {
        if (StrUtil.isEmpty((CharSequence)basicHeader) || !basicHeader.startsWith("Basic ")) {
            throw BizException.wrap((BaseExceptionCode)ExceptionCode.JWT_BASIC_INVALID);
        }
        String decodeBasic = StrUtil.subAfter((CharSequence)basicHeader, (CharSequence)"Basic ", (boolean)false);
        return JwtUtil.extractClient(decodeBasic);
    }

    public static String[] extractClient(String client) {
        String token = JwtUtil.base64Decoder(client);
        int index = token.indexOf(":");
        if (index == -1) {
            throw BizException.wrap((BaseExceptionCode)ExceptionCode.JWT_BASIC_INVALID);
        }
        return new String[]{token.substring(0, index), token.substring(index + 1)};
    }

    public static String base64Decoder(String header) {
        byte[] decoded = Base64.getDecoder().decode(header.getBytes(Charsets.UTF_8_NAME));
        return new String(decoded, Charsets.UTF_8_NAME);
    }

    public static Token createJWT(Map<String, String> user, long expire) {
        SignatureAlgorithm signatureAlgorithm = SignatureAlgorithm.HS256;
        long nowMillis = System.currentTimeMillis();
        Date now = new Date(nowMillis);
        byte[] apiKeySecretBytes = Base64.getDecoder().decode(BASE64_SECURITY);
        SecretKeySpec signingKey = new SecretKeySpec(apiKeySecretBytes, signatureAlgorithm.getJcaName());
        JwtBuilder builder = Jwts.builder().setHeaderParam("typ", (Object)"JsonWebToken").signWith(signatureAlgorithm, (Key)signingKey);
        user.forEach((arg_0, arg_1) -> ((JwtBuilder)builder).claim(arg_0, arg_1));
        long expMillis = nowMillis + expire * 1000L;
        Date exp = new Date(expMillis);
        builder.setExpiration(exp).setNotBefore(now);
        Token tokenInfo = new Token();
        tokenInfo.setToken(builder.compact());
        tokenInfo.setExpire(expire);
        tokenInfo.setExpiration(exp);
        return tokenInfo;
    }

    public static Claims parseJWT(String jsonWebToken) {
        try {
            return (Claims)Jwts.parserBuilder().setSigningKey(Base64.getDecoder().decode(BASE64_SECURITY)).build().parseClaimsJws(jsonWebToken).getBody();
        }
        catch (ExpiredJwtException ex) {
            log.error("token \u8fc7\u671f", (Throwable)ex);
            throw new BizException(ExceptionCode.JWT_TOKEN_EXPIRED.getCode(), ExceptionCode.JWT_TOKEN_EXPIRED.getMsg());
        }
        catch (SignatureException ex) {
            log.error("token \u7b7e\u540d\u9519\u8bef", (Throwable)ex);
            throw new BizException(ExceptionCode.JWT_SIGNATURE.getCode(), ExceptionCode.JWT_SIGNATURE.getMsg());
        }
        catch (IllegalArgumentException ex) {
            log.error("token \u4e3a\u7a7a", (Throwable)ex);
            throw new BizException(ExceptionCode.JWT_ILLEGAL_ARGUMENT.getCode(), ExceptionCode.JWT_ILLEGAL_ARGUMENT.getMsg());
        }
        catch (Exception e) {
            log.error("errcode:{}, message:{}", new Object[]{ExceptionCode.JWT_PARSER_TOKEN_FAIL.getCode(), e.getMessage(), e});
            throw new BizException(ExceptionCode.JWT_PARSER_TOKEN_FAIL.getCode(), ExceptionCode.JWT_PARSER_TOKEN_FAIL.getMsg());
        }
    }

    public static String getToken(String token) {
        if (token == null) {
            throw BizException.wrap((BaseExceptionCode)ExceptionCode.JWT_PARSER_TOKEN_FAIL);
        }
        if (token.startsWith("Bearer ")) {
            return StrUtil.subAfter((CharSequence)token, (CharSequence)"Bearer ", (boolean)false);
        }
        throw BizException.wrap((BaseExceptionCode)ExceptionCode.JWT_PARSER_TOKEN_FAIL);
    }

    public static Claims getClaims(String token) {
        if (token == null) {
            throw BizException.wrap((BaseExceptionCode)ExceptionCode.JWT_PARSER_TOKEN_FAIL);
        }
        if (token.startsWith("Bearer ")) {
            String headStr = StrUtil.subAfter((CharSequence)token, (CharSequence)"Bearer ", (boolean)false);
            return JwtUtil.parseJWT(headStr);
        }
        throw BizException.wrap((BaseExceptionCode)ExceptionCode.JWT_PARSER_TOKEN_FAIL);
    }
}

