/*
 * Decompiled with CFR 0.152.
 */
package com.github.zuihou.swagger2;

import com.github.xiaoymin.knife4j.spring.filter.ProductionSecurityFilter;
import com.github.xiaoymin.knife4j.spring.filter.SecurityBasicAuthFilter;
import com.github.xiaoymin.knife4j.spring.model.MarkdownFiles;
import com.github.zuihou.swagger2.SwaggerProperties;
import com.github.zuihou.swagger2.SwaggerWebMvcConfigurer;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.context.annotation.Import;
import springfox.bean.validators.configuration.BeanValidatorPluginsConfiguration;
import springfox.documentation.swagger2.annotations.EnableSwagger2;

@EnableSwagger2
@ComponentScan(basePackages={"com.github.xiaoymin.knife4j.spring.plugin", "com.github.xiaoymin.knife4j.spring.web"})
@ConditionalOnProperty(prefix="zuihou.swagger", name={"enabled"}, havingValue="true", matchIfMissing=true)
@Import(value={BeanValidatorPluginsConfiguration.class})
public class Swagger2Configuration {
    @Bean
    @ConditionalOnClass(value={SwaggerWebMvcConfigurer.class})
    public SwaggerWebMvcConfigurer getSwaggerWebMvcConfigurer() {
        return new SwaggerWebMvcConfigurer();
    }

    @Bean
    @ConditionalOnMissingBean
    @ConditionalOnProperty(prefix="zuihou.swagger", name={"production"}, havingValue="true")
    public ProductionSecurityFilter productionSecurityFilter(SwaggerProperties swaggerProperties) {
        return new ProductionSecurityFilter(swaggerProperties.getProduction().booleanValue());
    }

    @Bean
    @ConditionalOnMissingBean
    @ConditionalOnProperty(prefix="zuihou.swagger", name={"basic.enable"}, havingValue="true")
    public SecurityBasicAuthFilter securityBasicAuthFilter(SwaggerProperties swaggerProperties) {
        SwaggerProperties.Basic basic = swaggerProperties.getBasic();
        return new SecurityBasicAuthFilter(basic.getEnable().booleanValue(), basic.getUsername(), basic.getPassword());
    }

    @Bean(initMethod="init")
    @ConditionalOnMissingBean
    @ConditionalOnProperty(prefix="zuihou.swagger", name={"markdown.enable"}, havingValue="true")
    public MarkdownFiles markdownFiles(SwaggerProperties swaggerProperties) {
        return new MarkdownFiles(swaggerProperties.getMarkdown().getBasePath());
    }
}

