/*
 * Decompiled with CFR 0.152.
 */
package com.github.zuihou.validator.extract;

import com.github.zuihou.validator.extract.IConstraintExtract;
import com.github.zuihou.validator.mateconstraint.IConstraintConverter;
import com.github.zuihou.validator.mateconstraint.impl.NotNullConstraintConverter;
import com.github.zuihou.validator.mateconstraint.impl.OtherConstraintConverter;
import com.github.zuihou.validator.mateconstraint.impl.RangeConstraintConverter;
import com.github.zuihou.validator.mateconstraint.impl.RegExConstraintConverter;
import com.github.zuihou.validator.model.ConstraintInfo;
import com.github.zuihou.validator.model.FieldValidatorDesc;
import com.github.zuihou.validator.model.ValidConstraint;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.validation.Validator;
import org.hibernate.validator.internal.engine.ValidatorImpl;
import org.hibernate.validator.internal.metadata.BeanMetaDataManager;
import org.hibernate.validator.internal.metadata.aggregated.BeanMetaData;
import org.hibernate.validator.internal.metadata.core.MetaConstraint;
import org.hibernate.validator.internal.metadata.location.ConstraintLocation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultConstraintExtractImpl
implements IConstraintExtract {
    private static final Logger log = LoggerFactory.getLogger(DefaultConstraintExtractImpl.class);
    private Validator validator;
    private BeanMetaDataManager beanMetaDataManager;
    private List<IConstraintConverter> constraintConverters;

    public DefaultConstraintExtractImpl(Validator validator) {
        this.validator = validator;
        this.init();
    }

    public void init() {
        try {
            Field beanMetaDataManagerField = ValidatorImpl.class.getDeclaredField("beanMetaDataManager");
            beanMetaDataManagerField.setAccessible(true);
            this.beanMetaDataManager = (BeanMetaDataManager)beanMetaDataManagerField.get(this.validator);
            this.constraintConverters = new ArrayList<IConstraintConverter>(4);
            this.constraintConverters.add(new NotNullConstraintConverter());
            this.constraintConverters.add(new RangeConstraintConverter());
            this.constraintConverters.add(new RegExConstraintConverter());
            this.constraintConverters.add(new OtherConstraintConverter());
        }
        catch (IllegalAccessException | NoSuchFieldException e) {
            log.error("\u521d\u59cb\u5316\u9a8c\u8bc1\u5668\u5931\u8d25", (Throwable)e);
        }
    }

    @Override
    public Collection<FieldValidatorDesc> extract(List<ValidConstraint> constraints) throws Exception {
        if (constraints == null || constraints.size() == 0) {
            return Collections.EMPTY_LIST;
        }
        HashMap<String, FieldValidatorDesc> fieldValidatorDesc = new HashMap<String, FieldValidatorDesc>();
        for (ValidConstraint constraint : constraints) {
            this.doExtract(constraint, fieldValidatorDesc);
        }
        return fieldValidatorDesc.values();
    }

    private void doExtract(ValidConstraint constraint, Map<String, FieldValidatorDesc> fieldValidatorDesc) throws Exception {
        Class<?> targetClazz = constraint.getTarget();
        Class<?>[] groups = constraint.getGroups();
        BeanMetaData res = this.beanMetaDataManager.getBeanMetaData(targetClazz);
        Set r = res.getMetaConstraints();
        for (MetaConstraint metaConstraint : r) {
            this.builderFieldValidatorDesc(metaConstraint, groups, fieldValidatorDesc);
        }
    }

    private void builderFieldValidatorDesc(MetaConstraint<?> metaConstraint, Class<?>[] groups, Map<String, FieldValidatorDesc> fieldValidatorDescs) throws Exception {
        Set groupsMeta = metaConstraint.getGroupList();
        boolean isContainsGroup = false;
        block0: for (Class<?> group : groups) {
            if (groupsMeta.contains(group)) {
                isContainsGroup = true;
                break;
            }
            for (Class g : groupsMeta) {
                if (!g.isAssignableFrom(group)) continue;
                isContainsGroup = true;
                continue block0;
            }
        }
        if (!isContainsGroup) {
            return;
        }
        ConstraintLocation con = metaConstraint.getLocation();
        String domainName = con.getDeclaringClass().getSimpleName().toLowerCase();
        String fieldName = con.getMember().getName();
        String key = domainName + fieldName;
        FieldValidatorDesc desc = fieldValidatorDescs.get(domainName + fieldName);
        if (desc == null) {
            desc = new FieldValidatorDesc();
            desc.setDomainName(domainName);
            desc.setFieldName(fieldName);
            desc.setFieldType(this.getType(((Field)con.getMember()).getType()));
            desc.setConstraints(new ArrayList<ConstraintInfo>(5));
            fieldValidatorDescs.put(key, desc);
        }
        ConstraintInfo constraint = this.builderConstraint(metaConstraint.getDescriptor().getAnnotation());
        desc.getConstraints().add(constraint);
    }

    private String getType(Class<?> declaringClass) {
        if (Double.class.isAssignableFrom(declaringClass) || Float.class.isAssignableFrom(declaringClass)) {
            return "double";
        }
        if (Number.class.isAssignableFrom(declaringClass)) {
            return "int";
        }
        if (Date.class.isAssignableFrom(declaringClass)) {
            return "date";
        }
        if (CharSequence.class.isAssignableFrom(declaringClass)) {
            return "string";
        }
        return declaringClass.getSimpleName().toLowerCase();
    }

    private ConstraintInfo builderConstraint(Annotation annotation) throws Exception {
        for (IConstraintConverter constraintConverter : this.constraintConverters) {
            if (!constraintConverter.support(annotation.annotationType())) continue;
            return constraintConverter.converter(annotation);
        }
        return null;
    }
}

