/*
 * Decompiled with CFR 0.152.
 */
package com.github.zuihou.validator.mateconstraint.impl;

import com.github.zuihou.validator.mateconstraint.IConstraintConverter;
import com.github.zuihou.validator.model.ConstraintInfo;
import java.lang.annotation.Annotation;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;

public abstract class BaseConstraintConverter
implements IConstraintConverter {
    private List<String> methods = Collections.EMPTY_LIST;

    @Override
    public boolean support(Class<? extends Annotation> clazz) {
        if (this.getSupport().isEmpty()) {
            return true;
        }
        return clazz != null && this.getSupport().contains(clazz);
    }

    @Override
    public ConstraintInfo converter(Annotation ano) throws Exception {
        Class<?> clazz = ano.getClass();
        HashMap<String, Object> attr = new HashMap<String, Object>(4);
        for (String method : this.getMethods()) {
            Object value = clazz.getMethod(method, new Class[0]).invoke((Object)ano, new Object[0]);
            if (value != null && value instanceof String && ((String)value).contains("{")) {
                attr.put(method, "");
                continue;
            }
            attr.put(method, value);
        }
        return new ConstraintInfo().setType(this.getType(ano.annotationType())).setAttrs(attr);
    }

    protected abstract List<Class<? extends Annotation>> getSupport();

    protected List<String> getMethods() {
        return this.methods;
    }

    protected abstract String getType(Class<? extends Annotation> var1);
}

