package com.huifu.adapay.core.exception;
import com.huifu.adapay.core.exception.FailureCode;
/**
 * 异常
 * @author huifu.com
 */
public class BaseAdaPayException extends Exception {
    private String code;
    private String message;

    public BaseAdaPayException(String message) {
        this.message = message;
    }

    public BaseAdaPayException(String code, String message) {
        this.message = message;
        this.code = code;
    }

    public BaseAdaPayException(FailureCode codes) {
        this.message = codes.getFailureMsg();
        this.code = codes.getFailureCode();
    }

    @Override
    public String getMessage() {
        return message;
    }

    public String getCode() {
        return code;
    }

    @Override
    public String toString() {
        final StringBuilder sb = new StringBuilder("BaseAdaPayException{");
        sb.append("message='").append(message).append('\'');
        sb.append(", code='").append(code).append('\'');
        sb.append('}');
        return sb.toString();
    }
}
