package com.huifu.adapay.core.exception;

/**
 * @author huifu.com
 */
public enum FailureCode {

    /**
     * 参见 https://docs.adapay.tech/api/03-errors.html
     */
    REQUEST_PARAMETER_ERROR("request_parameter_error", "请求参数错误"),
    SYSTEM_EXCEPTION("system_exception", "系统异常"),
    HTTP_TIMEOUT_EXCEPTION("http_timeout_exception", "http请求超时,请检查网络是否正常或超时参数是否设置合理"),
    CONFIG_EXCEPTION("config_exception", "配置错误"),
    ADAPAY_FUNC_CODE_NOT_BLANK("adapay func code not blank", "adapay func code 不能为空"),
    SECURITY_EXCEPTION("security_exception", "签名错误"),
    TOKEN_REVOKE_ERROR("security_exception", "Token注销失败"),
    TOKEN_APPLY_ERROR("token_apply_error", "Token申请失败"),
    TOKEN_INVALIDED("token_invalided", "Token已失效"),
    CHARGE_ID_NOT_EXISTS("charge_id_not_exists", "对应支付记录不存在"),
    REQUEST_ORDER_NO_REPEATE("request_order_no_repeate", "请求订单号重复"),
    CHANNEL_ERROR("channel_error", "通道异常"),
    CHANNEL_RESPONSE_CODE_ERROR("channel_response_code_fail", "支付渠道响应码错误"),
    MER_NOT_REGISTER("mer_not_register", "商户未入驻"),
    ;

    FailureCode(String failureCode, String failureMsg) {
        this.failureCode = failureCode;
        this.failureMsg = failureMsg;
    }

    /**
     * 错误码
     */
    private String failureCode;

    /**
     * 错误描述
     */
    private String failureMsg;

    public String getFailureCode() {
        return failureCode;
    }

    public void setFailureCode(String failureCode) {
        this.failureCode = failureCode;
    }

    public String getFailureMsg() {
        return failureMsg;
    }

    public void setFailureMsg(String failureMsg) {
        this.failureMsg = failureMsg;
    }
}
