package com.huifu.adapay.core.model;

import com.alibaba.fastjson.annotation.JSONField;
import com.huifu.adapay.core.net.AbstractRequest;

/**
 * @author will.wang
 */
public class BaseModel extends AbstractRequest {
    /**
     * 返参，必填，交易状态：成功succeeded,处理中 pending, 或者 失败 failed
     */
    @JSONField(name="status")
    private String status;
    /**
     * 返参，可选，错误类型，可以是 invalid_request_error、api_error、channel_error 或 card_error
     */
    @JSONField(name="error_type")
    private String errorType;
    /**
     * 返参，可选，错误码，由第三方支付渠道返回的错误代码
     */
    @JSONField(name="error_code")
    private String errorCode;
    /**
     * 返参，可选，返回具体的错误描述
     */
    @JSONField(name="error_msg")
    private String errorMsg;
    /**
     * 返参，可选，当发生参数错误时返回具体的参数名，如 id
     */
    @JSONField(name="invalid_param")
    private String invalidParam;

    public String getStatus() {
        return status;
    }

    public String getErrorType() {
        return errorType;
    }

    public void setErrorType(String errorType) {
        this.errorType = errorType;
    }

    public String getErrorCode() {
        return errorCode;
    }

    public void setErrorCode(String errorCode) {
        this.errorCode = errorCode;
    }

    public String getErrorMsg() {
        return errorMsg;
    }

    public void setErrorMsg(String errorMsg) {
        this.errorMsg = errorMsg;
    }

    public String getInvalidParam() {
        return invalidParam;
    }

    public void setInvalidParam(String invalidParam) {
        this.invalidParam = invalidParam;
    }

    public void setStatus(String status) {
        this.status = status;
    }


    @Override
    public String toString() {
        return "BaseModel{" +
                "status='" + status + '\'' +
                ", type='" + errorType + '\'' +
                ", errorCode='" + errorCode + '\'' +
                ", errorMsg='" + errorMsg + '\'' +
                ", invalidParam='" + invalidParam + '\'' +
                '}';
    }
}
