package com.huifu.adapay.core.model;

import java.util.Map;

import com.huifu.adapay.core.AdapayCore;
import com.huifu.adapay.core.exception.BaseAdaPayException;
import com.huifu.adapay.core.model.BaseModel;

/**
 * 订阅异步消息用，商户无需关心
 * @author will.wang
 */
public class Token extends BaseModel {
    /**
     * token
     */
    private String token;

    /**
     * 获取token
     * @param params 获取token的请求参数
     * @return 获取的token对象
     * @throws BaseAdaPayException 异常
     */
    public static Map<String, Object> apply(Map<String, Object> params, String privateKey, String apiKey) throws BaseAdaPayException {
       
        return requestAdapayCore(RequestMethod.POST, AdapayCore.TOKEN_APPLY_V1, params, privateKey, apiKey);
    }

    /**
     * 销毁token
     * @param params 销毁token的请求参数
     * @return 销毁的token对象
     * @throws BaseAdaPayException 异常
     */
    public static Map<String, Object> revoke(Map<String, Object> params, String privateKey, String apiKey) throws BaseAdaPayException {
        return requestAdapayCore(RequestMethod.POST, AdapayCore.TOKEN_REVOKE_V1, params, privateKey, apiKey);
    }

    public String getToken() {
        return token;
    }

    public void setToken(String token) {
        this.token = token;
    }
}
