package com.huifu.adapay.core.util;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringWriter;
import java.io.Writer;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONException;

/**
 * @author adapay.com
 */
public class StreamUtil {

    private static final int DEFAULT_BUFFER_SIZE = 8192;

    /**
     * 从输入流读取内容, 写入到输出流中.  使用指定大小的缓冲区.
     * @param in 输入流
     * @param out 输出流
     * @param bufferSize 缓冲区大小(字节数)
     * @throws IOException 输入输出异常
     */
    public static void io(InputStream in, OutputStream out, int bufferSize)
            throws IOException {
        if (bufferSize == -1) {
            bufferSize = DEFAULT_BUFFER_SIZE;
        }

        byte[] buffer = new byte[bufferSize];
        int    amount;

        while ((amount = in.read(buffer)) >= 0) {
            out.write(buffer, 0, amount);
        }
    }

    /**
     * 从输入流读取内容, 写入到输出流中.  此方法使用大小为4096字符的默认的缓冲区.
     * @param in 输入流
     * @param out 输出流
     * @throws IOException 输入输出异常
     */
    public static void io(Reader in, Writer out) throws IOException {
        io(in, out, -1);
    }

    /**
     * 从输入流读取内容, 写入到输出流中.  使用指定大小的缓冲区.
     * @param in 输入流
     * @param out 输出流
     * @param bufferSize 缓冲区大小(字符数)
     * @throws IOException 输入输出异常
     */
    public static void io(Reader in, Writer out, int bufferSize)
            throws IOException {
        if (bufferSize == -1) {
            bufferSize = DEFAULT_BUFFER_SIZE >> 1;
        }

        char[] buffer = new char[bufferSize];
        int    amount;

        while ((amount = in.read(buffer)) >= 0) {
            out.write(buffer, 0, amount);
        }
    }

    /**
     * 将指定输入流的所有文本全部读出到一个字符串中.
     * @param in 要读取的输入流
     * @return 从输入流中取得的文本
     * @throws IOException 输入输出异常
     */
    public static String readText(InputStream in) throws IOException {
        return readText(in, null, -1);
    }

    /**
     * 将指定输入流的所有文本全部读出到一个字符串中.
     * @param in 要读取的输入流
     * @param encoding 文本编码方式
     * @return 从输入流中取得的文本
     * @throws IOException 输入输出异常
     */
    public static String readText(InputStream in, String encoding)
            throws IOException {
        return readText(in, encoding, -1);
    }

    /**
     * 将指定输入流的所有文本全部读出到一个字符串中.
     * @param in 要读取的输入流
     * @param encoding 文本编码方式
     * @param bufferSize 缓冲区大小(字符数)
     * @return 从输入流中取得的文本
     * @throws IOException 输入输出异常
     */
    public static String readText(InputStream in, String encoding, int bufferSize)
            throws IOException {
        Reader reader = (encoding == null) ? new InputStreamReader(in)
                : new InputStreamReader(in, encoding);

        return readText(reader, bufferSize);
    }

    /**
     * 将指定Reader的所有文本全部读出到一个字符串中.
     * @param reader 要读取的Reader
     * @param bufferSize 缓冲区的大小(字符数)
     * @return 从Reader中取得的文本
     * @throws IOException 输入输出异常
     */
    public static String readText(Reader reader, int bufferSize)
            throws IOException {
        StringWriter writer = new StringWriter();

        io(reader, writer, bufferSize);
        return writer.toString();
    }

    // public static MerConfig readMerConfigFromPath(String filePath) throws Exception{
    //     MerConfig merConfig = null;
    //     FileReader fileReader = null;
    //     BufferedReader bufferedReader = null;
    //     try {
    //         fileReader = new FileReader(new File(filePath));
    //         bufferedReader = new BufferedReader(fileReader);
    //         StringBuilder fileContentStr = new StringBuilder();
    //         String fileLineContent = bufferedReader.readLine();
    //         while (fileLineContent != null) {
    //             // 注释内容忽略
    //             if (fileLineContent.contains("*************")) {
    //                 fileLineContent = bufferedReader.readLine();
    //                 continue;
    //             }
    //             fileContentStr.append(fileLineContent);
    //             fileLineContent = bufferedReader.readLine();
    //         }

    //         String fileContent = fileContentStr.toString();
    //         System.out.println("fileContent"+fileContent);
    //         if (StringUtil.isEmpty(fileContent)) {
    //             System.out.println("配置文件内容为空");
    //             throw new Exception("配置文件内容为空");
    //         }

    //         merConfig = JSON.parseObject(fileContent, MerConfig.class);
    //         // merConfig = JSONObject.parseObject(is, charset, type, features)
    //     } catch (FileNotFoundException e) {
    //         System.out.println("配置文件不存在，请添加配置文件");
    //         e.printStackTrace();
    //         throw e;
    //     } catch (IOException e) {
    //         System.out.println("配置文件读取出错");
    //         e.printStackTrace();
    //         throw e;
    //     } catch (JSONException je) {
    //         System.out.println("配置文件格式错误，请检查配置信息");
    //         je.printStackTrace();
    //         throw je;
    //     } finally {
    //         closeQuietly(bufferedReader);
    //         closeQuietly(fileReader);
    //     }
        

    //     return merConfig;
    // }

    public static void closeQuietly(Reader input) {
        try {
            if (input != null) {
                input.close();
            }
        } catch (IOException var2) {
            ;
        }

    }

    public static void closeQuietly(Writer output) {
        try {
            if (output != null) {
                output.close();
            }
        } catch (IOException var2) {
            ;
        }

    }

    public static void closeQuietly(InputStream input) {
        try {
            if (input != null) {
                input.close();
            }
        } catch (IOException var2) {
            ;
        }

    }

    public static void closeQuietly(OutputStream output) {
        try {
            if (output != null) {
                output.close();
            }
        } catch (IOException var2) {
            ;
        }

    }

}
