/*
 * Decompiled with CFR 0.152.
 */
package com.jsoniter;

import com.jsoniter.CodegenImplNative;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import java.util.Vector;

class CodegenImplArray {
    static final Set<Class> WITH_CAPACITY_COLLECTION_CLASSES = new HashSet<Class>(){
        {
            this.add(ArrayList.class);
            this.add(HashSet.class);
            this.add(Vector.class);
        }
    };

    CodegenImplArray() {
    }

    public static String genArray(Class clazz) {
        Class<?> compType = clazz.getComponentType();
        if (compType.isArray()) {
            throw new IllegalArgumentException("nested array not supported: " + clazz.getCanonicalName());
        }
        StringBuilder lines = new StringBuilder();
        CodegenImplArray.append(lines, "com.jsoniter.CodegenAccess.resetExistingObject(iter);");
        CodegenImplArray.append(lines, "byte nextToken = com.jsoniter.CodegenAccess.readByte(iter);");
        CodegenImplArray.append(lines, "if (nextToken != '[') {");
        CodegenImplArray.append(lines, "if (nextToken == 'n') {");
        CodegenImplArray.append(lines, "com.jsoniter.CodegenAccess.skipFixedBytes(iter, 3);");
        CodegenImplArray.append(lines, "com.jsoniter.CodegenAccess.resetExistingObject(iter); return null;");
        CodegenImplArray.append(lines, "} else {");
        CodegenImplArray.append(lines, "nextToken = com.jsoniter.CodegenAccess.nextToken(iter);");
        CodegenImplArray.append(lines, "if (nextToken == 'n') {");
        CodegenImplArray.append(lines, "com.jsoniter.CodegenAccess.skipFixedBytes(iter, 3);");
        CodegenImplArray.append(lines, "com.jsoniter.CodegenAccess.resetExistingObject(iter); return null;");
        CodegenImplArray.append(lines, "}");
        CodegenImplArray.append(lines, "}");
        CodegenImplArray.append(lines, "}");
        CodegenImplArray.append(lines, "nextToken = com.jsoniter.CodegenAccess.nextToken(iter);");
        CodegenImplArray.append(lines, "if (nextToken == ']') {");
        CodegenImplArray.append(lines, "return new {{comp}}[0];");
        CodegenImplArray.append(lines, "}");
        CodegenImplArray.append(lines, "com.jsoniter.CodegenAccess.unreadByte(iter);");
        CodegenImplArray.append(lines, "{{comp}} a1 = {{op}};");
        CodegenImplArray.append(lines, "if (!com.jsoniter.CodegenAccess.nextTokenIsComma(iter)) {");
        CodegenImplArray.append(lines, "return new {{comp}}[]{ a1 };");
        CodegenImplArray.append(lines, "}");
        CodegenImplArray.append(lines, "{{comp}} a2 = {{op}};");
        CodegenImplArray.append(lines, "if (!com.jsoniter.CodegenAccess.nextTokenIsComma(iter)) {");
        CodegenImplArray.append(lines, "return new {{comp}}[]{ a1, a2 };");
        CodegenImplArray.append(lines, "}");
        CodegenImplArray.append(lines, "{{comp}} a3 = {{op}};");
        CodegenImplArray.append(lines, "if (!com.jsoniter.CodegenAccess.nextTokenIsComma(iter)) {");
        CodegenImplArray.append(lines, "return new {{comp}}[]{ a1, a2, a3 };");
        CodegenImplArray.append(lines, "}");
        CodegenImplArray.append(lines, "{{comp}} a4 = ({{comp}}) {{op}};");
        CodegenImplArray.append(lines, "if (!com.jsoniter.CodegenAccess.nextTokenIsComma(iter)) {");
        CodegenImplArray.append(lines, "return new {{comp}}[]{ a1, a2, a3, a4 };");
        CodegenImplArray.append(lines, "}");
        CodegenImplArray.append(lines, "{{comp}} a5 = ({{comp}}) {{op}};");
        CodegenImplArray.append(lines, "{{comp}}[] arr = new {{comp}}[10];");
        CodegenImplArray.append(lines, "arr[0] = a1;");
        CodegenImplArray.append(lines, "arr[1] = a2;");
        CodegenImplArray.append(lines, "arr[2] = a3;");
        CodegenImplArray.append(lines, "arr[3] = a4;");
        CodegenImplArray.append(lines, "arr[4] = a5;");
        CodegenImplArray.append(lines, "int i = 5;");
        CodegenImplArray.append(lines, "while (com.jsoniter.CodegenAccess.nextTokenIsComma(iter)) {");
        CodegenImplArray.append(lines, "if (i == arr.length) {");
        CodegenImplArray.append(lines, "{{comp}}[] newArr = new {{comp}}[arr.length * 2];");
        CodegenImplArray.append(lines, "System.arraycopy(arr, 0, newArr, 0, arr.length);");
        CodegenImplArray.append(lines, "arr = newArr;");
        CodegenImplArray.append(lines, "}");
        CodegenImplArray.append(lines, "arr[i++] = {{op}};");
        CodegenImplArray.append(lines, "}");
        CodegenImplArray.append(lines, "{{comp}}[] result = new {{comp}}[i];");
        CodegenImplArray.append(lines, "System.arraycopy(arr, 0, result, 0, i);");
        CodegenImplArray.append(lines, "return result;");
        return lines.toString().replace("{{comp}}", compType.getCanonicalName()).replace("{{op}}", CodegenImplNative.genReadOp(compType));
    }

    public static String genCollection(Class clazz, Type[] typeArgs) {
        if (WITH_CAPACITY_COLLECTION_CLASSES.contains(clazz)) {
            return CodegenImplArray.genCollectionWithCapacity(clazz, typeArgs[0]);
        }
        return CodegenImplArray.genCollectionWithoutCapacity(clazz, typeArgs[0]);
    }

    private static String genCollectionWithCapacity(Class clazz, Type compType) {
        StringBuilder lines = new StringBuilder();
        CodegenImplArray.append(lines, "{{clazz}} col = ({{clazz}})com.jsoniter.CodegenAccess.resetExistingObject(iter);");
        CodegenImplArray.append(lines, "if (iter.readNull()) { com.jsoniter.CodegenAccess.resetExistingObject(iter); return null; }");
        CodegenImplArray.append(lines, "if (!com.jsoniter.CodegenAccess.readArrayStart(iter)) {");
        CodegenImplArray.append(lines, "return col == null ? new {{clazz}}(0): ({{clazz}})com.jsoniter.CodegenAccess.reuseCollection(col);");
        CodegenImplArray.append(lines, "}");
        CodegenImplArray.append(lines, "Object a1 = {{op}};");
        CodegenImplArray.append(lines, "if (com.jsoniter.CodegenAccess.nextToken(iter) != ',') {");
        CodegenImplArray.append(lines, "{{clazz}} obj = col == null ? new {{clazz}}(1): ({{clazz}})com.jsoniter.CodegenAccess.reuseCollection(col);");
        CodegenImplArray.append(lines, "obj.add(a1);");
        CodegenImplArray.append(lines, "return obj;");
        CodegenImplArray.append(lines, "}");
        CodegenImplArray.append(lines, "Object a2 = {{op}};");
        CodegenImplArray.append(lines, "if (com.jsoniter.CodegenAccess.nextToken(iter) != ',') {");
        CodegenImplArray.append(lines, "{{clazz}} obj = col == null ? new {{clazz}}(2): ({{clazz}})com.jsoniter.CodegenAccess.reuseCollection(col);");
        CodegenImplArray.append(lines, "obj.add(a1);");
        CodegenImplArray.append(lines, "obj.add(a2);");
        CodegenImplArray.append(lines, "return obj;");
        CodegenImplArray.append(lines, "}");
        CodegenImplArray.append(lines, "Object a3 = {{op}};");
        CodegenImplArray.append(lines, "if (com.jsoniter.CodegenAccess.nextToken(iter) != ',') {");
        CodegenImplArray.append(lines, "{{clazz}} obj = col == null ? new {{clazz}}(3): ({{clazz}})com.jsoniter.CodegenAccess.reuseCollection(col);");
        CodegenImplArray.append(lines, "obj.add(a1);");
        CodegenImplArray.append(lines, "obj.add(a2);");
        CodegenImplArray.append(lines, "obj.add(a3);");
        CodegenImplArray.append(lines, "return obj;");
        CodegenImplArray.append(lines, "}");
        CodegenImplArray.append(lines, "Object a4 = {{op}};");
        CodegenImplArray.append(lines, "{{clazz}} obj = col == null ? new {{clazz}}(8): ({{clazz}})com.jsoniter.CodegenAccess.reuseCollection(col);");
        CodegenImplArray.append(lines, "obj.add(a1);");
        CodegenImplArray.append(lines, "obj.add(a2);");
        CodegenImplArray.append(lines, "obj.add(a3);");
        CodegenImplArray.append(lines, "obj.add(a4);");
        CodegenImplArray.append(lines, "while (com.jsoniter.CodegenAccess.nextToken(iter) == ',') {");
        CodegenImplArray.append(lines, "obj.add({{op}});");
        CodegenImplArray.append(lines, "}");
        CodegenImplArray.append(lines, "return obj;");
        return lines.toString().replace("{{clazz}}", clazz.getName()).replace("{{op}}", CodegenImplNative.genReadOp(compType));
    }

    private static String genCollectionWithoutCapacity(Class clazz, Type compType) {
        StringBuilder lines = new StringBuilder();
        CodegenImplArray.append(lines, "if (iter.readNull()) { com.jsoniter.CodegenAccess.resetExistingObject(iter); return null; }");
        CodegenImplArray.append(lines, "{{clazz}} col = ({{clazz}})com.jsoniter.CodegenAccess.resetExistingObject(iter);");
        CodegenImplArray.append(lines, "if (!com.jsoniter.CodegenAccess.readArrayStart(iter)) {");
        CodegenImplArray.append(lines, "return col == null ? new {{clazz}}(): ({{clazz}})com.jsoniter.CodegenAccess.reuseCollection(col);");
        CodegenImplArray.append(lines, "}");
        CodegenImplArray.append(lines, "Object a1 = {{op}};");
        CodegenImplArray.append(lines, "if (com.jsoniter.CodegenAccess.nextToken(iter) != ',') {");
        CodegenImplArray.append(lines, "{{clazz}} obj = col == null ? new {{clazz}}(): ({{clazz}})com.jsoniter.CodegenAccess.reuseCollection(col);");
        CodegenImplArray.append(lines, "obj.add(a1);");
        CodegenImplArray.append(lines, "return obj;");
        CodegenImplArray.append(lines, "}");
        CodegenImplArray.append(lines, "Object a2 = {{op}};");
        CodegenImplArray.append(lines, "if (com.jsoniter.CodegenAccess.nextToken(iter) != ',') {");
        CodegenImplArray.append(lines, "{{clazz}} obj = col == null ? new {{clazz}}(): ({{clazz}})com.jsoniter.CodegenAccess.reuseCollection(col);");
        CodegenImplArray.append(lines, "obj.add(a1);");
        CodegenImplArray.append(lines, "obj.add(a2);");
        CodegenImplArray.append(lines, "return obj;");
        CodegenImplArray.append(lines, "}");
        CodegenImplArray.append(lines, "Object a3 = {{op}};");
        CodegenImplArray.append(lines, "if (com.jsoniter.CodegenAccess.nextToken(iter) != ',') {");
        CodegenImplArray.append(lines, "{{clazz}} obj = col == null ? new {{clazz}}(): ({{clazz}})com.jsoniter.CodegenAccess.reuseCollection(col);");
        CodegenImplArray.append(lines, "obj.add(a1);");
        CodegenImplArray.append(lines, "obj.add(a2);");
        CodegenImplArray.append(lines, "obj.add(a3);");
        CodegenImplArray.append(lines, "return obj;");
        CodegenImplArray.append(lines, "}");
        CodegenImplArray.append(lines, "Object a4 = {{op}};");
        CodegenImplArray.append(lines, "{{clazz}} obj = col == null ? new {{clazz}}(): ({{clazz}})com.jsoniter.CodegenAccess.reuseCollection(col);");
        CodegenImplArray.append(lines, "obj.add(a1);");
        CodegenImplArray.append(lines, "obj.add(a2);");
        CodegenImplArray.append(lines, "obj.add(a3);");
        CodegenImplArray.append(lines, "obj.add(a4);");
        CodegenImplArray.append(lines, "while (com.jsoniter.CodegenAccess.nextToken(iter) == ',') {");
        CodegenImplArray.append(lines, "obj.add({{op}});");
        CodegenImplArray.append(lines, "}");
        CodegenImplArray.append(lines, "return obj;");
        return lines.toString().replace("{{clazz}}", clazz.getName()).replace("{{op}}", CodegenImplNative.genReadOp(compType));
    }

    private static void append(StringBuilder lines, String str) {
        lines.append(str);
        lines.append("\n");
    }
}

