/*
 * Decompiled with CFR 0.152.
 */
package com.jsoniter;

import com.jsoniter.Codegen;
import com.jsoniter.DecodingMode;
import com.jsoniter.DynamicCodegen;
import com.jsoniter.IterImpl;
import com.jsoniter.IterImplArray;
import com.jsoniter.IterImplForStreaming;
import com.jsoniter.IterImplNumber;
import com.jsoniter.IterImplObject;
import com.jsoniter.IterImplSkip;
import com.jsoniter.IterImplString;
import com.jsoniter.Slice;
import com.jsoniter.ValueType;
import com.jsoniter.annotation.JsoniterAnnotationSupport;
import com.jsoniter.any.Any;
import com.jsoniter.spi.JsonException;
import com.jsoniter.spi.TypeLiteral;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class JsonIterator
implements Closeable {
    private static boolean isStreamingEnabled = false;
    static final ValueType[] valueTypes = new ValueType[256];
    InputStream in;
    byte[] buf;
    int head;
    int tail;
    int skipStartedAt = -1;
    Map<String, Object> tempObjects = null;
    final Slice reusableSlice = new Slice(null, 0, 0);
    char[] reusableChars = new char[32];
    Object existingObject = null;
    private static final ReadArrayCallback fillArray;
    private static final ReadObjectCallback fillObject;
    public static ThreadLocal<JsonIterator> tlsIter;

    private JsonIterator(InputStream in, byte[] buf, int head, int tail) {
        this.in = in;
        this.buf = buf;
        this.head = head;
        this.tail = tail;
    }

    public JsonIterator() {
        this(null, new byte[0], 0, 0);
    }

    public static JsonIterator parse(InputStream in, int bufSize) {
        JsonIterator.enableStreamingSupport();
        return new JsonIterator(in, new byte[bufSize], 0, 0);
    }

    public static JsonIterator parse(byte[] buf) {
        return new JsonIterator(null, buf, 0, buf.length);
    }

    public static JsonIterator parse(byte[] buf, int head, int tail) {
        return new JsonIterator(null, buf, head, tail);
    }

    public static JsonIterator parse(String str) {
        return JsonIterator.parse(str.getBytes());
    }

    public static JsonIterator parse(Slice slice) {
        return new JsonIterator(null, slice.data(), slice.head(), slice.tail());
    }

    public final void reset(byte[] buf) {
        this.buf = buf;
        this.head = 0;
        this.tail = buf.length;
    }

    public final void reset(byte[] buf, int head, int tail) {
        this.buf = buf;
        this.head = head;
        this.tail = tail;
    }

    public final void reset(Slice value) {
        this.buf = value.data();
        this.head = value.head();
        this.tail = value.tail();
    }

    public final void reset(InputStream in) {
        this.in = in;
        this.head = 0;
        this.tail = 0;
    }

    @Override
    public final void close() throws IOException {
        if (this.in != null) {
            this.in.close();
        }
    }

    final void unreadByte() {
        if (this.head == 0) {
            throw this.reportError("unreadByte", "unread too many bytes");
        }
        --this.head;
    }

    public final JsonException reportError(String op, String msg) {
        int peekStart = this.head - 10;
        if (peekStart < 0) {
            peekStart = 0;
        }
        int peekSize = this.head - peekStart;
        if (this.head > this.tail) {
            peekSize = this.tail - peekStart;
        }
        String peek = new String(this.buf, peekStart, peekSize);
        throw new JsonException(op + ": " + msg + ", head: " + this.head + ", peek: " + peek + ", buf: " + new String(this.buf));
    }

    public final String currentBuffer() {
        int peekStart = this.head - 10;
        if (peekStart < 0) {
            peekStart = 0;
        }
        String peek = new String(this.buf, peekStart, this.head - peekStart);
        return "head: " + this.head + ", peek: " + peek + ", buf: " + new String(this.buf);
    }

    public final boolean readNull() throws IOException {
        byte c = IterImpl.nextToken(this);
        if (c != 110) {
            this.unreadByte();
            return false;
        }
        IterImpl.skipFixedBytes(this, 3);
        return true;
    }

    public final boolean readBoolean() throws IOException {
        byte c = IterImpl.nextToken(this);
        if (116 == c) {
            IterImpl.skipFixedBytes(this, 3);
            return true;
        }
        if (102 == c) {
            IterImpl.skipFixedBytes(this, 4);
            return false;
        }
        throw this.reportError("readBoolean", "expect t or f, found: " + c);
    }

    public final short readShort() throws IOException {
        int v = this.readInt();
        if (Short.MIN_VALUE <= v && v <= Short.MAX_VALUE) {
            return (short)v;
        }
        throw this.reportError("readShort", "short overflow: " + v);
    }

    public final int readInt() throws IOException {
        return IterImplNumber.readInt(this);
    }

    public final long readLong() throws IOException {
        return IterImplNumber.readLong(this);
    }

    public final boolean readArray() throws IOException {
        return IterImplArray.readArray(this);
    }

    public final boolean readArrayCB(ReadArrayCallback callback, Object attachment) throws IOException {
        return IterImplArray.readArrayCB(this, callback, attachment);
    }

    public final String readString() throws IOException {
        return IterImplString.readString(this);
    }

    public final Slice readStringAsSlice() throws IOException {
        return IterImpl.readSlice(this);
    }

    public final String readObject() throws IOException {
        return IterImplObject.readObject(this);
    }

    public final void readObjectCB(ReadObjectCallback cb, Object attachment) throws IOException {
        IterImplObject.readObjectCB(this, cb, attachment);
    }

    public final float readFloat() throws IOException {
        return IterImplNumber.readFloat(this);
    }

    public final double readDouble() throws IOException {
        return IterImplNumber.readDouble(this);
    }

    public final BigDecimal readBigDecimal() throws IOException {
        if (this.whatIsNext() != ValueType.NUMBER) {
            throw this.reportError("readBigDecimal", "not number");
        }
        return new BigDecimal(IterImplForStreaming.readNumber(this));
    }

    public final BigInteger readBigInteger() throws IOException {
        if (this.whatIsNext() != ValueType.NUMBER) {
            throw this.reportError("readBigDecimal", "not number");
        }
        return new BigInteger(IterImplForStreaming.readNumber(this));
    }

    public final Any readAny() throws IOException {
        try {
            return IterImpl.readAny(this);
        }
        catch (ArrayIndexOutOfBoundsException e) {
            throw this.reportError("read", "premature end");
        }
    }

    public final Object read() throws IOException {
        try {
            ValueType valueType = this.whatIsNext();
            switch (valueType) {
                case STRING: {
                    return this.readString();
                }
                case NUMBER: {
                    return this.readDouble();
                }
                case NULL: {
                    IterImpl.skipFixedBytes(this, 4);
                    return null;
                }
                case BOOLEAN: {
                    return this.readBoolean();
                }
                case ARRAY: {
                    ArrayList list = new ArrayList(4);
                    this.readArrayCB(fillArray, list);
                    return list;
                }
                case OBJECT: {
                    HashMap map = new HashMap(4);
                    this.readObjectCB(fillObject, map);
                    return map;
                }
            }
            throw this.reportError("read", "unexpected value type: " + (Object)((Object)valueType));
        }
        catch (ArrayIndexOutOfBoundsException e) {
            throw this.reportError("read", "premature end");
        }
    }

    public final <T> T read(T existingObject) throws IOException {
        try {
            this.existingObject = existingObject;
            Class<?> clazz = existingObject.getClass();
            return (T)Codegen.getDecoder(TypeLiteral.create(clazz).getDecoderCacheKey(), clazz).decode(this);
        }
        catch (ArrayIndexOutOfBoundsException e) {
            throw this.reportError("read", "premature end");
        }
    }

    public final <T> T read(TypeLiteral<T> typeLiteral, T existingObject) throws IOException {
        try {
            this.existingObject = existingObject;
            return (T)Codegen.getDecoder(typeLiteral.getDecoderCacheKey(), typeLiteral.getType()).decode(this);
        }
        catch (ArrayIndexOutOfBoundsException e) {
            throw this.reportError("read", "premature end");
        }
    }

    public final <T> T read(Class<T> clazz) throws IOException {
        try {
            return (T)Codegen.getDecoder(TypeLiteral.create(clazz).getDecoderCacheKey(), clazz).decode(this);
        }
        catch (ArrayIndexOutOfBoundsException e) {
            throw this.reportError("read", "premature end");
        }
    }

    public final <T> T read(TypeLiteral<T> typeLiteral) throws IOException {
        try {
            String cacheKey = typeLiteral.getDecoderCacheKey();
            return (T)Codegen.getDecoder(cacheKey, typeLiteral.getType()).decode(this);
        }
        catch (ArrayIndexOutOfBoundsException e) {
            throw this.reportError("read", "premature end");
        }
    }

    public ValueType whatIsNext() throws IOException {
        ValueType valueType = valueTypes[IterImpl.nextToken(this)];
        this.unreadByte();
        return valueType;
    }

    public void skip() throws IOException {
        IterImplSkip.skip(this);
    }

    public static final <T> T deserialize(String input, Class<T> clazz) {
        JsonIterator iter = tlsIter.get();
        byte[] bytes = input.getBytes();
        iter.reset(bytes);
        try {
            T val = iter.read(clazz);
            if (iter.head != bytes.length) {
                throw iter.reportError("deserialize", "trailing garbage found");
            }
            return val;
        }
        catch (ArrayIndexOutOfBoundsException e) {
            throw iter.reportError("deserialize", "premature end");
        }
        catch (IOException e) {
            throw new JsonException(e);
        }
    }

    public static final <T> T deserialize(String input, TypeLiteral<T> typeLiteral) {
        JsonIterator iter = tlsIter.get();
        iter.reset(input.getBytes());
        try {
            T val = iter.read(typeLiteral);
            if (IterImpl.nextToken(iter) != 0) {
                throw iter.reportError("deserialize", "trailing garbage found");
            }
            return val;
        }
        catch (ArrayIndexOutOfBoundsException e) {
            throw iter.reportError("deserialize", "premature end");
        }
        catch (IOException e) {
            throw new JsonException(e);
        }
    }

    public static final <T> T deserialize(byte[] input, Class<T> clazz) {
        JsonIterator iter = tlsIter.get();
        iter.reset(input);
        try {
            T val = iter.read(clazz);
            if (IterImpl.nextToken(iter) != 0) {
                throw iter.reportError("deserialize", "trailing garbage found");
            }
            return val;
        }
        catch (ArrayIndexOutOfBoundsException e) {
            throw iter.reportError("deserialize", "premature end");
        }
        catch (IOException e) {
            throw new JsonException(e);
        }
    }

    public static final <T> T deserialize(byte[] input, TypeLiteral<T> typeLiteral) {
        JsonIterator iter = tlsIter.get();
        iter.reset(input);
        try {
            T val = iter.read(typeLiteral);
            if (IterImpl.nextToken(iter) != 0) {
                throw iter.reportError("deserialize", "trailing garbage found");
            }
            return val;
        }
        catch (ArrayIndexOutOfBoundsException e) {
            throw iter.reportError("deserialize", "premature end");
        }
        catch (IOException e) {
            throw new JsonException(e);
        }
    }

    public static final Any deserialize(String input) {
        return JsonIterator.deserialize(input.getBytes());
    }

    public static final Any deserialize(byte[] input) {
        JsonIterator iter = tlsIter.get();
        iter.reset(input);
        try {
            Any val = iter.readAny();
            if (iter.head != input.length) {
                throw iter.reportError("deserialize", "trailing garbage found");
            }
            return val;
        }
        catch (ArrayIndexOutOfBoundsException e) {
            throw iter.reportError("deserialize", "premature end");
        }
        catch (IOException e) {
            throw new JsonException(e);
        }
    }

    public static void setMode(DecodingMode mode) {
        Codegen.setMode(mode);
    }

    public static void enableStreamingSupport() {
        if (isStreamingEnabled) {
            return;
        }
        isStreamingEnabled = true;
        try {
            DynamicCodegen.enableStreamingSupport();
        }
        catch (Exception e) {
            throw new JsonException(e);
        }
    }

    public static void enableAnnotationSupport() {
        JsoniterAnnotationSupport.enable();
    }

    static {
        for (int i = 0; i < valueTypes.length; ++i) {
            JsonIterator.valueTypes[i] = ValueType.INVALID;
        }
        JsonIterator.valueTypes[34] = ValueType.STRING;
        JsonIterator.valueTypes[45] = ValueType.NUMBER;
        JsonIterator.valueTypes[48] = ValueType.NUMBER;
        JsonIterator.valueTypes[49] = ValueType.NUMBER;
        JsonIterator.valueTypes[50] = ValueType.NUMBER;
        JsonIterator.valueTypes[51] = ValueType.NUMBER;
        JsonIterator.valueTypes[52] = ValueType.NUMBER;
        JsonIterator.valueTypes[53] = ValueType.NUMBER;
        JsonIterator.valueTypes[54] = ValueType.NUMBER;
        JsonIterator.valueTypes[55] = ValueType.NUMBER;
        JsonIterator.valueTypes[56] = ValueType.NUMBER;
        JsonIterator.valueTypes[57] = ValueType.NUMBER;
        JsonIterator.valueTypes[116] = ValueType.BOOLEAN;
        JsonIterator.valueTypes[102] = ValueType.BOOLEAN;
        JsonIterator.valueTypes[110] = ValueType.NULL;
        JsonIterator.valueTypes[91] = ValueType.ARRAY;
        JsonIterator.valueTypes[123] = ValueType.OBJECT;
        fillArray = new ReadArrayCallback(){

            @Override
            public boolean handle(JsonIterator iter, Object attachment) throws IOException {
                List list = (List)attachment;
                list.add(iter.read());
                return true;
            }
        };
        fillObject = new ReadObjectCallback(){

            @Override
            public boolean handle(JsonIterator iter, String field, Object attachment) throws IOException {
                Map map = (Map)attachment;
                map.put(field, iter.read());
                return true;
            }
        };
        tlsIter = new ThreadLocal<JsonIterator>(){

            @Override
            protected JsonIterator initialValue() {
                return new JsonIterator();
            }
        };
    }

    public static interface ReadObjectCallback {
        public boolean handle(JsonIterator var1, String var2, Object var3) throws IOException;
    }

    public static interface ReadArrayCallback {
        public boolean handle(JsonIterator var1, Object var2) throws IOException;
    }
}

