/*
 * Decompiled with CFR 0.152.
 */
package com.jsoniter.annotation;

import com.jsoniter.annotation.JsonCreator;
import com.jsoniter.annotation.JsonExtraProperties;
import com.jsoniter.annotation.JsonIgnore;
import com.jsoniter.annotation.JsonMissingProperties;
import com.jsoniter.annotation.JsonObject;
import com.jsoniter.annotation.JsonProperty;
import com.jsoniter.annotation.JsonUnwrapper;
import com.jsoniter.annotation.JsonWrapper;
import com.jsoniter.spi.Binding;
import com.jsoniter.spi.ClassDescriptor;
import com.jsoniter.spi.Decoder;
import com.jsoniter.spi.EmptyExtension;
import com.jsoniter.spi.Encoder;
import com.jsoniter.spi.JsonException;
import com.jsoniter.spi.JsoniterSpi;
import com.jsoniter.spi.ParameterizedTypeImpl;
import com.jsoniter.spi.TypeLiteral;
import com.jsoniter.spi.WrapperDescriptor;
import java.lang.annotation.Annotation;
import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class JsoniterAnnotationSupport
extends EmptyExtension {
    private static boolean enabled = false;

    public static void enable() {
        if (enabled) {
            return;
        }
        enabled = true;
        JsoniterSpi.registerExtension(new JsoniterAnnotationSupport());
    }

    @Override
    public void updateClassDescriptor(ClassDescriptor desc) {
        JsonObject jsonObject = desc.clazz.getAnnotation(JsonObject.class);
        if (jsonObject != null) {
            Binding binding;
            if (jsonObject.asExtraForUnknownProperties()) {
                desc.asExtraForUnknownProperties = true;
            }
            for (String fieldName : jsonObject.unknownPropertiesWhitelist()) {
                binding = new Binding(desc.clazz, desc.lookup, (Type)((Object)Object.class));
                binding.name = fieldName;
                binding.shouldSkip = true;
                desc.fields.add(binding);
            }
            for (String fieldName : jsonObject.unknownPropertiesBlacklist()) {
                binding = new Binding(desc.clazz, desc.lookup, (Type)((Object)Object.class));
                binding.name = fieldName;
                binding.asExtraWhenPresent = true;
                desc.fields.add(binding);
            }
        }
        ArrayList<Method> allMethods = new ArrayList<Method>();
        for (Class current = desc.clazz; current != null; current = current.getSuperclass()) {
            allMethods.addAll(Arrays.asList(current.getDeclaredMethods()));
        }
        this.updateBindings(desc);
        this.detectCtor(desc);
        this.detectStaticFactory(desc, allMethods);
        this.detectWrappers(desc, allMethods);
        this.detectUnwrappers(desc, allMethods);
    }

    private void detectUnwrappers(ClassDescriptor desc, List<Method> allMethods) {
        for (Method method : allMethods) {
            if (Modifier.isStatic(method.getModifiers()) || method.getAnnotation(JsonUnwrapper.class) == null) continue;
            desc.unWrappers.add(method);
        }
    }

    private void detectWrappers(ClassDescriptor desc, List<Method> allMethods) {
        for (Method method : allMethods) {
            if (Modifier.isStatic(method.getModifiers()) || method.getAnnotation(JsonWrapper.class) == null) continue;
            Annotation[][] annotations = method.getParameterAnnotations();
            String[] paramNames = this.getParamNames(method, annotations.length);
            WrapperDescriptor setter = new WrapperDescriptor();
            setter.method = method;
            for (int i = 0; i < annotations.length; ++i) {
                Annotation[] paramAnnotations = annotations[i];
                Binding binding = new Binding(desc.clazz, desc.lookup, method.getGenericParameterTypes()[i]);
                JsonProperty jsonProperty = this.getJsonProperty(paramAnnotations);
                if (jsonProperty != null) {
                    this.updateBindingWithJsonProperty(binding, jsonProperty);
                }
                if (binding.name == null || binding.name.length() == 0) {
                    binding.name = paramNames[i];
                }
                binding.annotations = paramAnnotations;
                setter.parameters.add(binding);
            }
            desc.wrappers.add(setter);
        }
    }

    private String[] getParamNames(Object obj, int paramCount) {
        String[] paramNames = new String[paramCount];
        try {
            Object params = this.reflectCall(obj, "getParameters", new Object[0]);
            for (int i = 0; i < paramNames.length; ++i) {
                paramNames[i] = (String)this.reflectCall(Array.get(params, i), "getName", new Object[0]);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return paramNames;
    }

    private Object reflectCall(Object obj, String methodName, Object ... args) throws Exception {
        Method method = obj.getClass().getMethod(methodName, new Class[0]);
        return method.invoke(obj, args);
    }

    private void detectStaticFactory(ClassDescriptor desc, List<Method> allMethods) {
        for (Method method : allMethods) {
            JsonCreator jsonCreator;
            if (!Modifier.isStatic(method.getModifiers()) || (jsonCreator = this.getJsonCreator(method.getAnnotations())) == null) continue;
            desc.ctor.staticMethodName = method.getName();
            desc.ctor.staticFactory = method;
            desc.ctor.ctor = null;
            Annotation[][] annotations = method.getParameterAnnotations();
            String[] paramNames = this.getParamNames(method, annotations.length);
            for (int i = 0; i < annotations.length; ++i) {
                Annotation[] paramAnnotations = annotations[i];
                JsonProperty jsonProperty = this.getJsonProperty(paramAnnotations);
                Binding binding = new Binding(desc.clazz, desc.lookup, method.getGenericParameterTypes()[i]);
                if (jsonProperty != null) {
                    this.updateBindingWithJsonProperty(binding, jsonProperty);
                }
                if (binding.name == null || binding.name.length() == 0) {
                    binding.name = paramNames[i];
                }
                binding.annotations = paramAnnotations;
                desc.ctor.parameters.add(binding);
            }
        }
    }

    private void detectCtor(ClassDescriptor desc) {
        for (Constructor<?> ctor : desc.clazz.getDeclaredConstructors()) {
            JsonCreator jsonCreator = this.getJsonCreator(ctor.getAnnotations());
            if (jsonCreator == null) continue;
            desc.ctor.staticMethodName = null;
            desc.ctor.ctor = ctor;
            desc.ctor.staticFactory = null;
            Annotation[][] annotations = ctor.getParameterAnnotations();
            String[] paramNames = this.getParamNames(ctor, annotations.length);
            for (int i = 0; i < annotations.length; ++i) {
                Annotation[] paramAnnotations = annotations[i];
                JsonProperty jsonProperty = this.getJsonProperty(paramAnnotations);
                Binding binding = new Binding(desc.clazz, desc.lookup, ctor.getGenericParameterTypes()[i]);
                if (jsonProperty != null) {
                    this.updateBindingWithJsonProperty(binding, jsonProperty);
                }
                if (binding.name == null || binding.name.length() == 0) {
                    binding.name = paramNames[i];
                }
                binding.annotations = paramAnnotations;
                desc.ctor.parameters.add(binding);
            }
        }
    }

    private void updateBindings(ClassDescriptor desc) {
        for (Binding binding : desc.allBindings()) {
            JsonProperty jsonProperty;
            JsonIgnore jsonIgnore = this.getJsonIgnore(binding.annotations);
            if (jsonIgnore != null && jsonIgnore.value()) {
                binding.fromNames = new String[0];
                binding.toNames = new String[0];
            }
            if ((jsonProperty = this.getJsonProperty(binding.annotations)) != null) {
                this.updateBindingWithJsonProperty(binding, jsonProperty);
            }
            if (JsoniterAnnotationSupport.getAnnotation(binding.annotations, JsonMissingProperties.class) != null) {
                binding.fromNames = new String[0];
                desc.onMissingProperties = binding;
            }
            if (JsoniterAnnotationSupport.getAnnotation(binding.annotations, JsonExtraProperties.class) == null) continue;
            binding.fromNames = new String[0];
            desc.onExtraProperties = binding;
        }
    }

    private void updateBindingWithJsonProperty(Binding binding, JsonProperty jsonProperty) {
        binding.asMissingWhenNotPresent = jsonProperty.required();
        binding.isNullable = jsonProperty.nullable();
        binding.isCollectionValueNullable = jsonProperty.collectionValueNullable();
        binding.shouldOmitNull = jsonProperty.omitNull();
        String altName = jsonProperty.value();
        if (!altName.isEmpty()) {
            binding.name = altName;
            binding.fromNames = new String[]{altName};
        }
        if (jsonProperty.from().length > 0) {
            binding.fromNames = jsonProperty.from();
        }
        if (jsonProperty.to().length > 0) {
            binding.toNames = jsonProperty.to();
        }
        if (jsonProperty.decoder() != Decoder.class) {
            try {
                binding.decoder = jsonProperty.decoder().newInstance();
            }
            catch (Exception e) {
                throw new JsonException(e);
            }
        }
        if (jsonProperty.encoder() != Encoder.class) {
            try {
                binding.encoder = jsonProperty.encoder().newInstance();
            }
            catch (Exception e) {
                throw new JsonException(e);
            }
        }
        if (jsonProperty.implementation() != Object.class) {
            binding.valueType = ParameterizedTypeImpl.useImpl(binding.valueType, jsonProperty.implementation());
            binding.valueTypeLiteral = TypeLiteral.create(binding.valueType);
        }
    }

    protected JsonCreator getJsonCreator(Annotation[] annotations) {
        return JsoniterAnnotationSupport.getAnnotation(annotations, JsonCreator.class);
    }

    protected JsonProperty getJsonProperty(Annotation[] annotations) {
        return JsoniterAnnotationSupport.getAnnotation(annotations, JsonProperty.class);
    }

    protected JsonIgnore getJsonIgnore(Annotation[] annotations) {
        return JsoniterAnnotationSupport.getAnnotation(annotations, JsonIgnore.class);
    }

    protected static <T extends Annotation> T getAnnotation(Annotation[] annotations, Class<T> annotationClass) {
        if (annotations == null) {
            return null;
        }
        for (Annotation annotation : annotations) {
            if (!annotationClass.isAssignableFrom(annotation.getClass())) continue;
            return (T)annotation;
        }
        return null;
    }
}

