/*
 * Decompiled with CFR 0.152.
 */
package com.jsoniter.any;

import com.jsoniter.CodegenAccess;
import com.jsoniter.JsonIterator;
import com.jsoniter.ValueType;
import com.jsoniter.any.Any;
import com.jsoniter.any.LazyAny;
import com.jsoniter.any.NotFoundAny;
import com.jsoniter.output.JsonStream;
import com.jsoniter.spi.JsonException;
import com.jsoniter.spi.TypeLiteral;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

class ArrayLazyAny
extends LazyAny {
    private static final TypeLiteral<List<Any>> typeLiteral = new TypeLiteral<List<Any>>(){};
    private List<Any> cache;
    private int lastParsedPos;

    public ArrayLazyAny(byte[] data, int head, int tail) {
        super(data, head, tail);
        this.lastParsedPos = head;
    }

    @Override
    public ValueType valueType() {
        return ValueType.ARRAY;
    }

    @Override
    public Object object() {
        this.fillCache();
        return this.cache;
    }

    @Override
    public boolean toBoolean() {
        try {
            return CodegenAccess.readArrayStart(this.parse());
        }
        catch (IOException e) {
            throw new JsonException(e);
        }
    }

    @Override
    public int toInt() {
        return this.size();
    }

    @Override
    public long toLong() {
        return this.size();
    }

    @Override
    public float toFloat() {
        return this.size();
    }

    @Override
    public double toDouble() {
        return this.size();
    }

    @Override
    public int size() {
        this.fillCache();
        return this.cache.size();
    }

    @Override
    public Iterator<Any> iterator() {
        if (this.lastParsedPos == this.tail) {
            return this.cache.iterator();
        }
        return new LazyIterator();
    }

    @Override
    public Any get(int index) {
        try {
            return this.fillCacheUntil(index);
        }
        catch (IndexOutOfBoundsException e) {
            return new NotFoundAny(index, this.object());
        }
    }

    @Override
    public Any get(Object[] keys, int idx) {
        if (idx == keys.length) {
            return this;
        }
        Object key = keys[idx];
        if (this.isWildcard(key)) {
            this.fillCache();
            ArrayList<Any> result = new ArrayList<Any>();
            for (Any element : this.cache) {
                Any mapped = element.get(keys, idx + 1);
                if (mapped.valueType() == ValueType.INVALID) continue;
                result.add(mapped);
            }
            return Any.rewrap(result);
        }
        try {
            return this.fillCacheUntil((Integer)key).get(keys, idx + 1);
        }
        catch (IndexOutOfBoundsException e) {
            return new NotFoundAny(keys, idx, this.object());
        }
        catch (ClassCastException e) {
            return new NotFoundAny(keys, idx, this.object());
        }
    }

    private void fillCache() {
        if (this.lastParsedPos == this.tail) {
            return;
        }
        if (this.cache == null) {
            this.cache = new ArrayList<Any>(4);
        }
        try {
            JsonIterator iter = JsonIterator.tlsIter.get();
            iter.reset(this.data, this.lastParsedPos, this.tail);
            if (this.lastParsedPos == this.head) {
                if (!CodegenAccess.readArrayStart(iter)) {
                    this.lastParsedPos = this.tail;
                    return;
                }
                this.cache.add(iter.readAny());
            }
            while (CodegenAccess.nextToken(iter) == 44) {
                this.cache.add(iter.readAny());
            }
            this.lastParsedPos = this.tail;
        }
        catch (IOException e) {
            throw new JsonException(e);
        }
    }

    private Any fillCacheUntil(int target) {
        int i;
        if (this.lastParsedPos == this.tail) {
            return this.cache.get(target);
        }
        if (this.cache == null) {
            this.cache = new ArrayList<Any>(4);
        }
        if (target < (i = this.cache.size())) {
            return this.cache.get(target);
        }
        try {
            Any element;
            JsonIterator iter = JsonIterator.tlsIter.get();
            iter.reset(this.data, this.lastParsedPos, this.tail);
            if (this.lastParsedPos == this.head) {
                if (!CodegenAccess.readArrayStart(iter)) {
                    this.lastParsedPos = this.tail;
                    throw new IndexOutOfBoundsException();
                }
                element = iter.readAny();
                this.cache.add(element);
                if (target == 0) {
                    this.lastParsedPos = CodegenAccess.head(iter);
                    return element;
                }
                i = 1;
            }
            while (CodegenAccess.nextToken(iter) == 44) {
                element = iter.readAny();
                this.cache.add(element);
                if (i++ != target) continue;
                this.lastParsedPos = CodegenAccess.head(iter);
                return element;
            }
            this.lastParsedPos = this.tail;
        }
        catch (IOException e) {
            throw new JsonException(e);
        }
        throw new IndexOutOfBoundsException();
    }

    @Override
    public void writeTo(JsonStream stream) throws IOException {
        if (this.lastParsedPos == this.head) {
            super.writeTo(stream);
        } else {
            this.fillCache();
            stream.writeVal(typeLiteral, this.cache);
        }
    }

    @Override
    public String toString() {
        if (this.lastParsedPos == this.head) {
            return super.toString();
        }
        this.fillCache();
        return JsonStream.serialize(this.cache);
    }

    private class LazyIterator
    implements Iterator<Any> {
        private final int cacheSize;
        private int cachePos;

        public LazyIterator() {
            try {
                if (ArrayLazyAny.this.cache == null) {
                    ArrayLazyAny.this.cache = new ArrayList(4);
                }
                if (ArrayLazyAny.this.lastParsedPos == ArrayLazyAny.this.head) {
                    JsonIterator iter = JsonIterator.tlsIter.get();
                    iter.reset(ArrayLazyAny.this.data, ArrayLazyAny.this.lastParsedPos, ArrayLazyAny.this.tail);
                    if (!CodegenAccess.readArrayStart(iter)) {
                        ArrayLazyAny.this.lastParsedPos = ArrayLazyAny.this.tail;
                    } else {
                        ArrayLazyAny.this.lastParsedPos = CodegenAccess.head(iter);
                    }
                }
            }
            catch (IOException e) {
                throw new JsonException(e);
            }
            this.cacheSize = ArrayLazyAny.this.cache.size();
            this.cachePos = 0;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean hasNext() {
            return this.cachePos != this.cacheSize || ArrayLazyAny.this.lastParsedPos != ArrayLazyAny.this.tail;
        }

        @Override
        public Any next() {
            try {
                return this.next_();
            }
            catch (IOException e) {
                throw new JsonException(e);
            }
        }

        private Any next_() throws IOException {
            if (this.cachePos != this.cacheSize) {
                return (Any)ArrayLazyAny.this.cache.get(this.cachePos++);
            }
            JsonIterator iter = JsonIterator.tlsIter.get();
            iter.reset(ArrayLazyAny.this.data, ArrayLazyAny.this.lastParsedPos, ArrayLazyAny.this.tail);
            Any element = iter.readAny();
            ArrayLazyAny.this.cache.add(element);
            if (CodegenAccess.nextToken(iter) == 44) {
                ArrayLazyAny.this.lastParsedPos = CodegenAccess.head(iter);
            } else {
                ArrayLazyAny.this.lastParsedPos = ArrayLazyAny.this.tail;
            }
            return element;
        }
    }
}

