/*
 * Decompiled with CFR 0.152.
 */
package com.jsoniter.any;

import com.jsoniter.CodegenAccess;
import com.jsoniter.JsonIterator;
import com.jsoniter.ValueType;
import com.jsoniter.any.Any;
import com.jsoniter.any.LazyAny;
import com.jsoniter.any.NotFoundAny;
import com.jsoniter.output.JsonStream;
import com.jsoniter.spi.JsonException;
import com.jsoniter.spi.TypeLiteral;
import java.io.IOException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

class ObjectLazyAny
extends LazyAny {
    private static final TypeLiteral<Map<String, Any>> typeLiteral = new TypeLiteral<Map<String, Any>>(){};
    private Map<String, Any> cache;
    private int lastParsedPos;

    public ObjectLazyAny(byte[] data, int head, int tail) {
        super(data, head, tail);
        this.lastParsedPos = head;
    }

    @Override
    public ValueType valueType() {
        return ValueType.OBJECT;
    }

    @Override
    public Object object() {
        this.fillCache();
        return this.cache;
    }

    @Override
    public boolean toBoolean() {
        try {
            return CodegenAccess.readObjectStart(this.parse());
        }
        catch (IOException e) {
            throw new JsonException(e);
        }
    }

    @Override
    public int toInt() {
        return this.size();
    }

    @Override
    public long toLong() {
        return this.size();
    }

    @Override
    public float toFloat() {
        return this.size();
    }

    @Override
    public double toDouble() {
        return this.size();
    }

    @Override
    public int size() {
        this.fillCache();
        return this.cache.size();
    }

    @Override
    public Set<String> keys() {
        this.fillCache();
        return this.cache.keySet();
    }

    @Override
    public Any get(Object key) {
        Any element = this.fillCacheUntil(key);
        if (element == null) {
            return new NotFoundAny(key, this.object());
        }
        return element;
    }

    @Override
    public Any get(Object[] keys, int idx) {
        if (idx == keys.length) {
            return this;
        }
        Object key = keys[idx];
        if (this.isWildcard(key)) {
            this.fillCache();
            HashMap<String, Any> result = new HashMap<String, Any>();
            for (Map.Entry<String, Any> entry : this.cache.entrySet()) {
                Any mapped = entry.getValue().get(keys, idx + 1);
                if (mapped.valueType() == ValueType.INVALID) continue;
                result.put(entry.getKey(), mapped);
            }
            return Any.rewrap(result);
        }
        Any child = this.fillCacheUntil(key);
        if (child == null) {
            return new NotFoundAny(keys, idx, this.object());
        }
        return child.get(keys, idx + 1);
    }

    private Any fillCacheUntil(Object target) {
        Any value;
        if (this.lastParsedPos == this.tail) {
            return this.cache.get(target);
        }
        if (this.cache == null) {
            this.cache = new HashMap<String, Any>(4);
        }
        if ((value = this.cache.get(target)) != null) {
            return value;
        }
        try {
            String field;
            JsonIterator iter = JsonIterator.tlsIter.get();
            iter.reset(this.data, this.lastParsedPos, this.tail);
            if (this.lastParsedPos == this.head) {
                if (!CodegenAccess.readObjectStart(iter)) {
                    this.lastParsedPos = this.tail;
                    return null;
                }
                field = CodegenAccess.readObjectFieldAsString(iter);
                value = iter.readAny();
                this.cache.put(field, value);
                if (field.hashCode() == target.hashCode() && field.equals(target)) {
                    this.lastParsedPos = CodegenAccess.head(iter);
                    return value;
                }
            }
            while (CodegenAccess.nextToken(iter) == 44) {
                field = CodegenAccess.readObjectFieldAsString(iter);
                value = iter.readAny();
                this.cache.put(field, value);
                if (field.hashCode() != target.hashCode() || !field.equals(target)) continue;
                this.lastParsedPos = CodegenAccess.head(iter);
                return value;
            }
            this.lastParsedPos = this.tail;
            return null;
        }
        catch (IOException e) {
            throw new JsonException(e);
        }
    }

    private void fillCache() {
        if (this.lastParsedPos == this.tail) {
            return;
        }
        if (this.cache == null) {
            this.cache = new HashMap<String, Any>(4);
        }
        try {
            String field;
            JsonIterator iter = JsonIterator.tlsIter.get();
            iter.reset(this.data, this.lastParsedPos, this.tail);
            if (this.lastParsedPos == this.head) {
                if (!CodegenAccess.readObjectStart(iter)) {
                    this.lastParsedPos = this.tail;
                    return;
                }
                field = CodegenAccess.readObjectFieldAsString(iter);
                this.cache.put(field, iter.readAny());
            }
            while (CodegenAccess.nextToken(iter) == 44) {
                field = CodegenAccess.readObjectFieldAsString(iter);
                this.cache.put(field, iter.readAny());
            }
            this.lastParsedPos = this.tail;
        }
        catch (IOException e) {
            throw new JsonException(e);
        }
    }

    @Override
    public Any.EntryIterator entries() {
        return new LazyIterator();
    }

    @Override
    public void writeTo(JsonStream stream) throws IOException {
        if (this.lastParsedPos == this.head) {
            super.writeTo(stream);
        } else {
            this.fillCache();
            stream.writeVal(typeLiteral, this.cache);
        }
    }

    @Override
    public String toString() {
        if (this.lastParsedPos == this.head) {
            return super.toString();
        }
        this.fillCache();
        return JsonStream.serialize(this.cache);
    }

    private class LazyIterator
    implements Any.EntryIterator {
        private Iterator<Map.Entry<String, Any>> mapIter;
        private String key;
        private Any value;

        public LazyIterator() {
            if (ObjectLazyAny.this.cache == null) {
                ObjectLazyAny.this.cache = new HashMap();
            }
            this.mapIter = new HashMap(ObjectLazyAny.this.cache).entrySet().iterator();
            try {
                if (ObjectLazyAny.this.lastParsedPos == ObjectLazyAny.this.head) {
                    JsonIterator iter = JsonIterator.tlsIter.get();
                    iter.reset(ObjectLazyAny.this.data, ObjectLazyAny.this.lastParsedPos, ObjectLazyAny.this.tail);
                    if (!CodegenAccess.readObjectStart(iter)) {
                        ObjectLazyAny.this.lastParsedPos = ObjectLazyAny.this.tail;
                    } else {
                        ObjectLazyAny.this.lastParsedPos = CodegenAccess.head(iter);
                    }
                }
            }
            catch (IOException e) {
                throw new JsonException(e);
            }
        }

        @Override
        public boolean next() {
            if (ObjectLazyAny.this.lastParsedPos == ObjectLazyAny.this.tail) {
                return false;
            }
            if (this.mapIter != null) {
                if (this.mapIter.hasNext()) {
                    Map.Entry<String, Any> entry = this.mapIter.next();
                    this.key = entry.getKey();
                    this.value = entry.getValue();
                    return true;
                }
                this.mapIter = null;
            }
            try {
                JsonIterator iter = JsonIterator.tlsIter.get();
                iter.reset(ObjectLazyAny.this.data, ObjectLazyAny.this.lastParsedPos, ObjectLazyAny.this.tail);
                this.key = CodegenAccess.readObjectFieldAsString(iter);
                this.value = iter.readAny();
                ObjectLazyAny.this.cache.put(this.key, this.value);
                if (CodegenAccess.nextToken(iter) == 44) {
                    ObjectLazyAny.this.lastParsedPos = CodegenAccess.head(iter);
                } else {
                    ObjectLazyAny.this.lastParsedPos = ObjectLazyAny.this.tail;
                }
            }
            catch (IOException e) {
                throw new JsonException(e);
            }
            return true;
        }

        @Override
        public String key() {
            return this.key;
        }

        @Override
        public Any value() {
            return this.value;
        }
    }
}

