/*
 * Decompiled with CFR 0.152.
 */
package com.jsoniter.any;

import com.jsoniter.CodegenAccess;
import com.jsoniter.JsonIterator;
import com.jsoniter.ValueType;
import com.jsoniter.any.LazyAny;
import com.jsoniter.spi.JsonException;
import java.io.IOException;

class StringLazyAny
extends LazyAny {
    private static final String FALSE = "false";
    private String cache;

    public StringLazyAny(byte[] data, int head, int tail) {
        super(data, head, tail);
    }

    @Override
    public ValueType valueType() {
        return ValueType.STRING;
    }

    @Override
    public Object object() {
        this.fillCache();
        return this.cache;
    }

    @Override
    public boolean toBoolean() {
        this.fillCache();
        int len = this.cache.length();
        if (len == 0) {
            return false;
        }
        if (len == 5 && FALSE.equals(this.cache)) {
            return false;
        }
        block3: for (int i = 0; i < len; ++i) {
            switch (this.cache.charAt(i)) {
                case '\t': 
                case '\n': 
                case '\r': 
                case ' ': {
                    continue block3;
                }
                default: {
                    return true;
                }
            }
        }
        return false;
    }

    @Override
    public int toInt() {
        try {
            JsonIterator iter = this.parse();
            CodegenAccess.nextToken(iter);
            return iter.readInt();
        }
        catch (IOException e) {
            throw new JsonException(e);
        }
    }

    @Override
    public long toLong() {
        try {
            JsonIterator iter = this.parse();
            CodegenAccess.nextToken(iter);
            return iter.readLong();
        }
        catch (IOException e) {
            throw new JsonException(e);
        }
    }

    @Override
    public float toFloat() {
        try {
            JsonIterator iter = this.parse();
            CodegenAccess.nextToken(iter);
            return iter.readFloat();
        }
        catch (IOException e) {
            throw new JsonException(e);
        }
    }

    @Override
    public double toDouble() {
        try {
            JsonIterator iter = this.parse();
            CodegenAccess.nextToken(iter);
            return iter.readDouble();
        }
        catch (IOException e) {
            throw new JsonException(e);
        }
    }

    @Override
    public String toString() {
        this.fillCache();
        return this.cache;
    }

    private void fillCache() {
        if (this.cache == null) {
            try {
                this.cache = this.parse().readString();
            }
            catch (IOException e) {
                throw new JsonException();
            }
        }
    }
}

